/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.payment.authority;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.CommonPayImpl;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.authority.AuthorityQueryPayImpl;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.PaymentUtils;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class AuthorityPayImpl
extends CommonPayImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AuthorityPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AuthorityQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "gaoqiangyao";
    }

    public String getBizCode() {
        return "P1CMSETB0";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e8c\u6b21\u5ba1\u6838\u652f\u4ed8\u63a5\u53e3", (String)"AuthorityPayImpl_1", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest payRequest) {
        List paymentInfos = payRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String kdFlag = PaymentUtils.getKD(paymentInfo);
        LoginUtils.login(this.logger);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSETB0", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntityForAuthority();
        body.addContent((Content)request);
        String cusname = RequestContextUtils.getBankParameterValue((String)"cusoprname");
        if (StringUtils.isEmpty((String)cusname)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6388\u6743\u652f\u4ed8\u4e1a\u52a1\u7684'\u5236\u5355\u5458\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e'\u4e2d\u8fdb\u884c\u914d\u7f6e\u3002", (String)"AuthorityPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
        }
        JDomExtUtils.addChildCDData(request, "TDP_Nm", cusname);
        JDomExtUtils.addChildCDData(request, "Entp_Opr_TpCD", "01");
        JDomExtUtils.addChildCDData(request, "Pcs_Bsn_TpCd", "001");
        JDomExtUtils.addChildCDData(request, "EMP_ELCBNK_SVAR_ID", RequestContextUtils.getBankParameterValue((String)"custid"));
        JDomExtUtils.addChildCDData(request, "CstPty_Py_Jrnl_No", kdFlag);
        JDomExtUtils.addChildCDData(request, "Pyr_BkCgyCd", "01");
        JDomExtUtils.addChildCDData(request, "Pyr_Cst_AccNo", paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData(request, "Pyr_AccNm", paymentInfo.getAccName());
        JDomExtUtils.addChildCDData(request, "Pyr_Acc_CgyCd", "02");
        JDomExtUtils.addChildCDData(request, "RcvPrt_BkCgyCd", paymentInfo.is2SameBank() ? "01" : "02");
        JDomExtUtils.addChildCDData(request, "RcvPrt_Cst_AccNo", paymentInfo.getIncomeAccNo());
        JDomExtUtils.addChildCDData(request, "RcvPrt_DpBkNm", paymentInfo.getIncomeBankName());
        JDomExtUtils.addChildCDData(request, "RcvPtAc_Nm", paymentInfo.getIncomeAccName());
        JDomExtUtils.addChildCDData(request, "RcvPrt_BnkCD", paymentInfo.getIncomeCnaps());
        JDomExtUtils.addChildCDData(request, "RcvPrt_Adr", paymentInfo.getIncomeBankAddress());
        JDomExtUtils.addChildCDData(request, "Rmrk", paymentInfo.getExplanation());
        JDomExtUtils.addChildCDData(request, "Py_Cnd_TpCd", "00");
        JDomExtUtils.addChildCDData(request, "RvPy_ExMd_Cd", "0");
        JDomExtUtils.addChildCDData(request, "Cst_Dlv_Dt", DateUtil.formatDate((Date)new Date()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("hhmmssSSS");
        try {
            JDomExtUtils.addChildCDData(request, "Cst_Dlv_Tm", dateFormat.format(new Date()));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u65f6\u95f4\u51fa\u9519\u3002", (String)"AuthorityPayImpl_3", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
        }
        JDomExtUtils.addChildCDData(request, "Rqs_Amt", paymentInfo.getAmount().toString());
        JDomExtUtils.addChildCDData(request, "Urgnt_TpCd", paymentInfo.is2Urgent() ? "02" : "01");
        if ("pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            JDomExtUtils.addChildCDData(request, "Use_Nm", ResManager.loadKDString((String)"\u5185\u90e8\u8d44\u91d1\u8c03\u62e8", (String)"AuthorityPayImpl_4", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
        }
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"AuthorityPayImpl_5", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String resultCode = "";
        String bankMsg = "";
        String bankCode = "";
        if (null != response) {
            resultCode = JDomExtUtils.getChildText((Element)response, (String)"CshMgt_Txn_Rslt_Cd");
            bankMsg = JDomExtUtils.getChildText((Element)response, (String)"Err_Inf");
            bankCode = JDomExtUtils.getChildText((Element)response, (String)"CshMgt_Err_Cd");
        } else {
            bankMsg = bankResp.getBankMsg();
            bankCode = bankResp.getResponseCode();
        }
        if ("1".equalsIgnoreCase(resultCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"AuthorityPayImpl_6", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankCode, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"AuthorityPayImpl_6", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
        } else if ("2".equalsIgnoreCase(resultCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"AuthorityPayImpl_5", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankCode, (String)bankMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"AuthorityPayImpl_7", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankCode, (String)bankMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

