/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynhtb.dc.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynhtb.dc.utils.YnhtbPacker;
import kd.ebg.aqap.banks.ynhtb.dc.utils.YnhtbParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        return this.packHisBalance(bankBalanceRequest);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        return this.parseHisBalance(bankBalanceRequest, responseStr);
    }

    public LocalDate limitDate() {
        return LocalDate.of(1970, 1, 1);
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "500003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-ynhtb-dc", (Object[])new Object[0]);
    }

    public String packHisBalance(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        String startDate = request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String endDate = request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Element root = YnhtbPacker.packRoot();
        Element reqData = JDomUtils.addChild((Element)root, (String)"ReqData");
        Element header = YnhtbPacker.packReqHead("500003", Sequence.genSequence());
        JDomUtils.addChild((Element)reqData, (Element)header);
        Element reqParam = JDomUtils.addChild((Element)reqData, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)reqParam, (String)"BeginDate", (String)startDate);
        JDomUtils.addChild((Element)reqParam, (String)"EndDate", (String)endDate);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parseHisBalance(BankBalanceRequest request, String rspStr) {
        Element root = YnhtbParser.parseString2Root(rspStr);
        Element rspData = JDomUtils.getChildElement((Element)root, (String)"RspData");
        Element rspHead = rspData == null ? JDomUtils.getChildElement((Element)root, (String)"RspHead") : JDomUtils.getChildElement((Element)rspData, (String)"RspHead");
        ArrayList<BalanceInfo> hisBalanceList = new ArrayList<BalanceInfo>(16);
        boolean success = YnhtbParser.parseRspHead(rspHead);
        if (success) {
            Element result = JDomUtils.getChildElement((Element)rspData, (String)"Result");
            String num = JDomUtils.getChildTextTrim((Element)result, (String)"Num");
            Element list = JDomUtils.getChildElement((Element)result, (String)"List");
            List tranInfos = list.getChildren("TranInfo");
            for (Object transInfoObj : tranInfos) {
                BalanceInfo balanceInfo = new BalanceInfo();
                Element transInfo = (Element)transInfoObj;
                balanceInfo.setBankAcnt(request.getAcnt());
                balanceInfo.setBankCurrency(request.getBankCurrency());
                String tranDate = JDomUtils.getChildTextTrim((Element)transInfo, (String)"TranDate");
                this.setBalanceDateTime(balanceInfo, tranDate + "000000", DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss"));
                String balance = JDomUtils.getChildTextTrim((Element)transInfo, (String)"AvailBal");
                this.setCurrentBalance(balanceInfo, balance);
                this.setAvailableBalance(balanceInfo, balance);
                hisBalanceList.add(balanceInfo);
            }
        }
        return new EBBankBalanceResponse(hisBalanceList);
    }
}

