/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        String reqMsg = "xhj0004#" + bankAcnt.getAccNo() + "#@@@@";
        return reqMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        String bankCurrency = bankBalanceRequest.getBankCurrency();
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(bankAcnt);
        String[] repInfo = responseStr.split("#");
        String reponse_code = repInfo[0];
        if (!"000000".equalsIgnoreCase(reponse_code)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)reponse_code, (String)""));
        }
        String repAccNo = repInfo[1];
        String BALANCE = repInfo[2];
        this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), repAccNo);
        String availBal = repInfo[3];
        this.setCurrentBalance(balanceInfo, BALANCE);
        this.setAvailableBalance(balanceInfo, availBal);
        this.setBankCurrency(balanceInfo, bankCurrency);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        bankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return bankBalanceResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "xhj0004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u8d26\u6237\u4f59\u989d\u67e5\u8be2\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }
}

