/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.allocation;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hxb.dc.services.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.Packer;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AllocationPayImpl
extends AbstractPayImpl
implements IPay,
HXB_DC_Constants {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "xhj0008";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u96c6\u56e2\u5185\u8d44\u91d1\u8c03\u62e8", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return this.isAllocation(paymentInfo) || "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && UseConvertor.isTransfer((PaymentInfo)paymentInfo) && !BankBusinessConfig.isTransferToCompany();
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u96c6\u56e2\u5185\u8d44\u91d1\u8c03\u62e8(xhj0008)\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"AllocationPayImpl_1", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymenInfo = (PaymentInfo)paymentInfos.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("xhj0008");
        sb.append('#');
        sb.append(paymenInfo.getPackageId());
        sb.append('#');
        sb.append(paymenInfo.getAccNo());
        sb.append('#');
        sb.append(paymenInfo.getAmount().setScale(2, 5).toString());
        sb.append('#');
        sb.append(paymenInfo.getIncomeAccNo());
        sb.append('#');
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            if (!StringUtils.isEmpty((String)paymenInfo.getExplanation())) {
                sb.append(Packer.getKDExp(paymenInfo));
            } else {
                sb.append(Packer.getKDExp(paymenInfo, ""));
            }
        } else {
            sb.append(paymenInfo.getExplanation());
        }
        sb.append('#');
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        try {
            String responseCode = elements[0];
            String responseMsg = "";
            responseMsg = elements.length > 1 ? String.format(ResManager.loadKDString((String)"\u62a5\u6587\u6807\u8bc6:%1$s\uff0c\u4f59\u989d:%2$s\u3002", (String)"AllocationPayImpl_10", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[0], elements[1]) : String.format(ResManager.loadKDString((String)"\u62a5\u6587\u6807\u8bc6:%s\u3002", (String)"AllocationPayImpl_11", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[0]);
            if ("000000".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"AllocationPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)"", (String)"");
            } else if ("EL4114".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"AllocationPayImpl_6", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)ResManager.loadKDString((String)"\u8d26\u53f7\u6216\u5361\u53f7\u65e0\u6548\u3002", (String)"AllocationPayImpl_7", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"AllocationPayImpl_8", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)responseMsg);
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5:%s\u3002", (String)"AllocationPayImpl_12", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

