/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzccb.dc.service.payment;

import java.time.LocalDateTime;
import java.util.Arrays;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzccb.dc.service.payment.CompanyQueryPayDetailImpl;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.RequestPacker;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.ResponseParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CompanyQueryPayImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return this.packQueryPay(bankPayRequest.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        this.parseQueryPay(bankPayRequest.getPaymentInfoAsArray(), res);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String packQueryPay(PaymentInfo[] paymentInfos) {
        Element head = RequestPacker.getHeadPackerData("200112", "0", Sequence.genSequence());
        Element body = RequestPacker.getQueryPayBody(paymentInfos);
        String requestStr = RequestPacker.getRequest(head, body);
        return requestStr;
    }

    public void parseQueryPay(PaymentInfo[] paymentInfos, String response) throws EBServiceException {
        Element element = CommonUtil.getResponseElement(response);
        Element head = element.getChild("head");
        Element body = element.getChild("body");
        BankResponse headRsp = CommonUtil.parseBankResponse(head);
        String bankStatus = headRsp.getResponseCode();
        if (!"0_0000".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            String recordNumStr = body.getChildTextTrim("record_num");
            String fieldNumStr = body.getChildTextTrim("field_num");
            String fileFlag = head.getChildTextTrim("file_flag");
            if (StringUtils.isEmpty((String)fieldNumStr) || StringUtils.isEmpty((String)recordNumStr)) {
                logger.info("====\u672c\u6b21\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a====");
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]));
                return;
            }
            int fieldNum = Integer.parseInt(fieldNumStr);
            int recordNum = Integer.parseInt(recordNumStr);
            if (fieldNum <= 0 || recordNum <= 0) {
                logger.info("===\u672c\u6b21\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a====");
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]));
                return;
            }
            String content = ResponseParser.resContentHandle(body, fileFlag);
            String[][] rs = ResponseParser.parseContent(content, recordNum, fieldNum);
            this.parsePayInfo(paymentInfos, rs);
        }
    }

    public void parsePayInfo(PaymentInfo[] paymentInfos, String[][] rs) throws EBServiceException {
        String batchSeqId = paymentInfos[0].getBankBatchSeqId();
        logger.info("batchSeqId\uff1a" + batchSeqId);
        for (int i = 0; i < rs.length; ++i) {
            String serialNo = rs[i][0];
            String batchNo = rs[i][1];
            String stat = rs[i][13];
            logger.info("batch_no\uff1a" + batchNo + ",serial_no:" + serialNo);
            if (batchSeqId.equals(batchNo)) {
                logger.info("batchSeqId \u5339\u914d\u6210\u529f\uff01");
                logger.info("===\u5f00\u59cb\u67e5\u8be2\u652f\u4ed8\u660e\u7ec6===\u5f53\u524d\u660e\u7ec6\u6d41\u6c34\uff1a" + serialNo);
                logger.info("===\u6279\u72b6\u6001\u4e3a===" + stat);
                if ("1".equals(stat)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)stat, (String)ResManager.loadKDString((String)"\u6279\u6b21\u4ed8\u6b3e\u5931\u8d25", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]));
                    break;
                }
                RequestContextUtils.setRunningParam((String)"serialNo", (String)serialNo);
                RequestContextUtils.setRunningParam((String)"bankBatchSeqId", (String)batchSeqId);
                LocalDateTime requestTime = paymentInfos[0].getRequestTime();
                RequestContextUtils.setRunningParam((String)"requestTime", (String)LocalDateUtil.formatDate((LocalDateTime)requestTime));
                BankPayRequest bankPayRequest = new BankPayRequest();
                bankPayRequest.setPaymentInfos(Arrays.asList(paymentInfos));
                CompanyQueryPayDetailImpl companyQueryPayDetail = new CompanyQueryPayDetailImpl();
                companyQueryPayDetail.doBiz(bankPayRequest);
                continue;
            }
            logger.info("batchSeqId \u5339\u914d\u5931\u8d25");
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200112";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]);
    }
}

