/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.szns.dc.services.payment;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.szns.dc.services.payment.Packer;
import kd.ebg.aqap.banks.szns.dc.services.payment.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.sdk.ebg.trd.exception.SDKException;
import kd.sdk.ebg.trd.jdom.SDKElement;
import kd.sdk.ebg.trd.jdom.SDKElementUtil;

public class QryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        try {
            List paymentInfos = bankPayRequest.getPaymentInfos();
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
            SDKElement root = Packer.buildHead("B2ETrsResultQry", Sequence.gen18Sequence());
            SDKElement Map2 = SDKElementUtil.getChild((SDKElement)root, (String)"Body");
            SDKElementUtil.addChild((SDKElement)Map2, (String)"HistoryERPJnlNo", (String)paymentInfo.getBankBatchSeqId());
            return SDKElementUtil.root2String((SDKElement)root, (String)RequestContextUtils.getCharset());
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        try {
            List paymentInfos = bankPayRequest.getPaymentInfos();
            SDKElement root = SDKElementUtil.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            BankResponse bankResponse = Parser.parseHeader(root);
            if (!"000000".equals(bankResponse.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QryPaymentImpl_0", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                return new EBBankPayResponse(paymentInfos);
            }
            SDKElement mapElement = root.getChild("Body");
            String returnCode = SDKElementUtil.getChildTextTrim((SDKElement)mapElement, (String)"ReturnCode");
            String TrsStateCode = SDKElementUtil.getChildTextTrim((SDKElement)mapElement, (String)"TrsStateCode");
            String TrsStateMsg = SDKElementUtil.getChildTextTrim((SDKElement)mapElement, (String)"TrsStateMsg");
            HashMap<String, String> tranStatMap = new HashMap<String, String>(){
                {
                    this.put("00", ResManager.loadKDString((String)"\u51b2\u6b63", (String)"QryPaymentImpl_1", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]));
                    this.put("01", ResManager.loadKDString((String)"\u6210\u529f", (String)"QryPaymentImpl_2", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]));
                    this.put("02", ResManager.loadKDString((String)"\u5931\u8d25", (String)"QryPaymentImpl_3", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]));
                    this.put("03", ResManager.loadKDString((String)"\u5df2\u9000\u6c47", (String)"QryPaymentImpl_4", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]));
                    this.put("04", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u4eba\u884c", (String)"QryPaymentImpl_5", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]));
                }
            };
            if ("01".equals(TrsStateCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryPaymentImpl_6", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]), (String)TrsStateCode, (String)((String)tranStatMap.get(TrsStateCode)));
            } else if ("00".equals(TrsStateCode) || "02".equals(TrsStateCode) || "03".equals(TrsStateCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QryPaymentImpl_7", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]), (String)TrsStateCode, (String)((String)tranStatMap.get(TrsStateCode)));
            } else if ("04".equals(TrsStateCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QryPaymentImpl_8", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]), (String)TrsStateCode, (String)((String)tranStatMap.get(TrsStateCode)));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QryPaymentImpl_0", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]), (String)TrsStateCode, (String)((String)tranStatMap.get(TrsStateCode)));
            }
            return new EBBankPayResponse(paymentInfos);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/" + this.getBizCode() + ".do?userPassword=";
        s = s + RequestContextUtils.getParameter().getBankParameter("OpNo") + "&SIGDATA=1";
        factory.setUri(s);
        super.configFactory(factory);
    }

    public String getDeveloper() {
        return "SIMON";
    }

    public String getBizCode() {
        return "B2ETrsResultQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u4ea4\u6613\u72b6\u6001\u67e5\u8be2", (String)"QryPaymentImpl_9", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]);
    }
}

