/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.curandfixed.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.service.curandfixed.notice2cur.NTSMACNLImpl;
import kd.ebg.aqap.banks.cmb.opa.service.curandfixed.notice2cur.QueryNotify;
import kd.ebg.aqap.banks.cmb.opa.service.curandfixed.query.RequestForReqnbr;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractQueryCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.IQueryCurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;

public class QueryCurAndFixedBizImpl
extends AbstractQueryCAFImpl
implements IQueryCurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryCurAndFixedBizImpl.class);

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        String bizCode = "NTFNCDTL";
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        JSONObject ntdtlfncx = new JSONObject();
        logger.info("\u83b7\u53d6\u5230\u7684\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u4e3a{}", (Object)((CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0)).getReqNbr());
        ntdtlfncx.put("reqnbr", (Object)((CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0)).getReqNbr());
        JSONArray array = new JSONArray();
        array.add((Object)ntdtlfncx);
        JSONObject body = new JSONObject();
        body.put("ntdtlfncx", (Object)array);
        JSONObject request = JsonUtil.getrequest(head, body);
        if (EBContext.getContext().isUnitTest()) {
            return "";
        }
        return MsgPacker.getSendMsg(request, logger, bizCode);
    }

    public EBBankCurAndFixedResponse doBiz(BankCurAndFixedRequest rqst) {
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)rqst.getCafInfos().get(0);
        try {
            if ("cancelNotification".equalsIgnoreCase(rqst.getHeader().getSubBizType())) {
                if (CurAndFixedState.NTS_CANCEL_REQ == CurAndFixedState.getEnumById((int)curAndFixedInfo.getStatus())) {
                    return new NTSMACNLImpl().currentAndFixed(rqst);
                }
                QueryNotify.getInstance().setNotifyID(rqst);
                EBBankCurAndFixedResponse resp = new EBBankCurAndFixedResponse();
                resp.setDetails(rqst.getCafInfos());
                if (CurAndFixedState.NTS_CANCEL_FINISHED.getId() == curAndFixedInfo.getStatus().intValue()) {
                    return resp;
                }
                if (CurAndFixedState.SUCCESS.getId() == curAndFixedInfo.getStatus().intValue() || CurAndFixedState.SUBMITED.getId() == curAndFixedInfo.getStatus().intValue()) {
                    curAndFixedInfo.setStatus(Integer.valueOf(CurAndFixedState.NTS_CANCEL_SUBMITTED.getId()));
                } else {
                    curAndFixedInfo.setStatus(Integer.valueOf(CurAndFixedState.NTS_CANCEL_FAILED.getId()));
                }
                return resp;
            }
            if (curAndFixedInfo.isATC()) {
                if (QueryNotify.getInstance().setNotifyID(rqst) && RequestForReqnbr.getInstance().setReqnbr(rqst)) {
                    String rqstStr = this.pack(rqst);
                    String rspStr = PostUtil.sendMsg(rqstStr);
                    return this.parse(rqst, rspStr);
                }
                List cafInfos = rqst.getCafInfos();
                EBBankCurAndFixedResponse resp = new EBBankCurAndFixedResponse();
                resp.setDetails(cafInfos);
                return resp;
            }
            if (RequestForReqnbr.getInstance().setReqnbr(rqst)) {
                String rqstStr = this.pack(rqst);
                String rspStr = PostUtil.sendMsg(rqstStr);
                return this.parse(rqst, rspStr);
            }
            List cafInfos = rqst.getCafInfos();
            EBBankCurAndFixedResponse resp = new EBBankCurAndFixedResponse();
            resp.setDetails(cafInfos);
            return resp;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        String res = MsgParser.getReceMsg(s, logger);
        return this.parse(res, bankCurAndFixedRequest);
    }

    public EBBankCurAndFixedResponse parse(String res, BankCurAndFixedRequest bankCurAndFixedRequest) {
        Date date;
        CurAndFixedInfo curAndFixedInfo;
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        BankResponse response = MsgParser.getResponse(res, logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"QueryCurAndFixedBizImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)res);
        JSONObject resp = request.getJSONObject("response");
        JSONObject head = resp.getJSONObject("head");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntdtlfncz = body.getJSONArray("ntdtlfncz");
        if (!ntdtlfncz.isEmpty()) {
            JSONObject detail = ntdtlfncz.getJSONObject(0);
            curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
            String reqnbr = detail.getString("reqnbr");
            String oprtyp = detail.getString("oprtyp");
            String bbknbr = detail.getString("bbknbr");
            String accnbr = detail.getString("accnbr");
            String accnam = detail.getString("accnam");
            String cltnam = detail.getString("cltnam");
            String fixbbk = detail.getString("fixbbk");
            String fixacc = detail.getString("fixacc");
            String ccynbr = detail.getString("ccynbr");
            String inftyp = detail.getString("inftyp");
            String brnnam = detail.getString("brnnam");
            String terdum = detail.getString("terdum");
            String terdur = detail.getString("terdur");
            String atoflg = detail.getString("atoflg");
            String intdat = detail.getString("intdat");
            String expdat = detail.getString("expdat");
            String intrat = detail.getString("intrat");
            String intamt = detail.getString("intamt");
            String trsamt = detail.getString("trsamt");
            String yurref = detail.getString("yurref");
            String reqsta = detail.getString("reqsta");
            String rtnflg = detail.getString("rtnflg");
            String oprdat = detail.getString("oprdat");
            curAndFixedInfo.setReqNbr(reqnbr);
            curAndFixedInfo.setAcntBankNo(bbknbr);
            curAndFixedInfo.setAccNo(accnbr);
            curAndFixedInfo.setFixedAcntBankNo(fixbbk);
            curAndFixedInfo.setFixedAccNo(fixacc);
            curAndFixedInfo.setFixedAccName(accnam);
            curAndFixedInfo.setCurrency(ccynbr);
            curAndFixedInfo.setDepositTermValue(terdum);
            if ("1".equals(atoflg)) {
                atoflg = "0";
            } else if ("3".equals(atoflg)) {
                atoflg = "1";
            }
            curAndFixedInfo.setExpireOp(atoflg);
            curAndFixedInfo.setRateDate(intdat);
            curAndFixedInfo.setEndDate(expdat);
            curAndFixedInfo.setRate(intrat);
            curAndFixedInfo.setFixActInt(intamt);
            curAndFixedInfo.setAmount(trsamt);
            curAndFixedInfo.setBankStatusMsg(rtnflg);
            date = new Date();
            try {
                date = DateTimeUtils.parseDate((String)oprdat, (String)"yyyyMMdd");
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u8fc7\u7a0b\u8fd4\u56de\u4e86\u7a7a\u6570\u636e\u3002", (String)"QueryCurAndFixedBizImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        curAndFixedInfo.setTranDate(localDateTime);
        CAFUtil.setState((CurAndFixedInfo)curAndFixedInfo, (CurAndFixedState)CurAndFixedState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryCurAndFixedBizImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)"", (String)"");
        ebBankCurAndFixedResponse.setDetails(cafInfos);
        return ebBankCurAndFixedResponse;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "NTFNCDTL";
    }

    public String getBizDesc() {
        return null;
    }
}

