/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.salary.individual;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryIndividualPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryIndividualPaymentImpl.class);

    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject jsonObject = new JSONObject();
        String busmode = UseConvertor.isSalary((PaymentInfo)((PaymentInfo)paymentInfos.get(0))) ? "N03010" : "N03020";
        jsonObject.put("buscod", (Object)busmode);
        jsonObject.put("yurref", (Object)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JSONArray bb6bpdqyy1 = new JSONArray();
        bb6bpdqyy1.add((Object)jsonObject);
        JSONObject bb6bpdqyy1Body = new JSONObject();
        String jsonArray = RequestContextUtils.getRunningParam((String)"bb6bpdqyy1");
        if (StringUtils.isNotEmpty((String)jsonArray)) {
            bb6bpdqyy1 = JSONArray.parseArray((String)jsonArray);
        }
        bb6bpdqyy1Body.put("bb6bpdqyy1", (Object)bb6bpdqyy1);
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, (JSONObject)JSONObject.toJSON((Object)bb6bpdqyy1Body));
        return MsgPacker.getSendMsg(request, this.logger, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String res = MsgParser.getReceMsg(rspStr, this.logger);
        BankResponse response = MsgParser.getResponse(res, this.logger);
        if ("SUC0000".equalsIgnoreCase(response.getResponseCode())) {
            JSONObject request = JSONObject.parseObject((String)res);
            JSONObject resp = request.getJSONObject("response");
            JSONObject body = resp.getJSONObject("body");
            JSONArray bb6bpdqyy1 = body.getJSONArray("bb6bpdqyy1");
            if (bb6bpdqyy1 == null) {
                this.setLastPage(true);
            } else {
                this.setLastPage(false);
                RequestContextUtils.setRunningParam((String)"bb6bpdqyy1", (String)bb6bpdqyy1.toJSONString());
            }
            JSONArray bb6bpdqyz2 = body.getJSONArray("bb6bpdqyz2");
            if (bb6bpdqyz2 == null) {
                this.logger.info("==\u6ca1\u6709\u4ed8\u6b3e\u72b6\u6001\u660e\u7ec6\u8fd4\u56de==");
                return new EBBankPayResponse(paymentInfos);
            }
            HashMap<String, PaymentInfo> paymentInfoMap = new HashMap<String, PaymentInfo>(16);
            for (PaymentInfo paymentInfo : paymentInfos) {
                paymentInfoMap.put(paymentInfo.getBankRefID(), paymentInfo);
            }
            for (int i = 0; i < bb6bpdqyz2.size(); ++i) {
                JSONObject jsonObject = (JSONObject)bb6bpdqyz2.get(i);
                String errtxt = jsonObject.getString("errtxt");
                String trxseq = (String)jsonObject.get((Object)"trxseq");
                String status = (String)jsonObject.get((Object)"stscod");
                PaymentInfo paymentInfo = (PaymentInfo)paymentInfoMap.get(trxseq);
                if (paymentInfo == null) {
                    this.logger.info("\u5bf9\u5e94\u7684\u5e8f\u5217\u53f7{}\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed8\u6b3e\u4fe1\u606f", (Object)trxseq);
                    continue;
                }
                this.setPaymentState(status, errtxt, body, paymentInfo);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void setPaymentState(String status, String errtxt, JSONObject body, PaymentInfo paymentInfo) {
        if (this.isPaymentFail(status, body)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)status, (String)errtxt);
        } else if ("S".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)status, (String)"");
        } else if ("A".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)status, (String)errtxt);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)status, (String)errtxt);
        }
    }

    public boolean isPaymentFail(String status, JSONObject body) {
        if ("A".equals(status)) {
            boolean emptyFlag = body == null || body.isEmpty();
            JSONArray bb6bpdqyz1 = new JSONArray();
            if (!emptyFlag) {
                bb6bpdqyz1 = body.getJSONArray("bb6bpdqyz1");
                boolean bl = emptyFlag = bb6bpdqyz1 == null || bb6bpdqyz1.isEmpty();
            }
            if (!emptyFlag && bb6bpdqyz1.size() == 1) {
                JSONObject object = bb6bpdqyz1.getJSONObject(0);
                String stscod = object.getString("stscod");
                String rtnflg = object.getString("rtnflg");
                return "R".equals(rtnflg) && "C".equals(stscod);
            }
            return false;
        }
        return "E".equals(status);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BB6BPDQY";
    }

    public String getBizDesc() {
        return null;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        try {
            this.setLastPage(true);
            ArrayList PaymentInfos = new ArrayList();
            do {
                String rqstStr = this.pack(request);
                String rspStr = PostUtil.sendMsg(rqstStr);
                EBBankPayResponse parse = this.parse(request, rspStr);
                PaymentInfos.addAll(parse.getPaymentInfos());
            } while (!this.isLastPage());
            return new EBBankPayResponse(PaymentInfos);
        }
        catch (Exception e) {
            this.logger.error("\u4ed8\u6b3e\u67e5\u8be2\u5904\u7406\u5f02\u5e38==={}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }
}

