/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.token;

import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.exception.SdkException;
import com.czb.sap.sdk.inf.GetTokenIn;
import com.czb.sap.sdk.inf.GetTokenOut;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.ebg.aqap.banks.zsb.opa.ZsbOpaMetaDataImpl;
import kd.ebg.aqap.banks.zsb.opa.services.utils.CacheUtils;
import kd.ebg.aqap.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.IToken;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TokenService
implements IToken {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TokenService.class);
    public static final String TOKEN_ERROR = "token";
    private static TokenService instance;

    public static synchronized TokenService getInstance() {
        if (instance == null) {
            instance = new TokenService();
        }
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getToken() {
        String appId = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.appid);
        String key = CacheUtils.getKey(appId);
        String token = CacheUtils.get(appId);
        if (StringUtils.isEmpty((String)token)) {
            DLock lock = DLock.create((String)key, (String)String.format(ResManager.loadKDString((String)"%s\u83b7\u53d6token\u5206\u5e03\u5f0f\u9501\u3002", (String)"TokenService_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), appId));
            try {
                long time;
                if (lock.tryLock()) {
                    token = CacheUtils.get(appId);
                    if (!StringUtils.isEmpty((String)token)) return token;
                    token = TokenService.getTokenFromBank(appId);
                    CacheUtils.putIfAbsentWithExpire(appId, token, 15, TimeUnit.MINUTES);
                    return token;
                }
                for (time = 180000L; time >= 0L && !StringUtils.isNotEmpty((String)(token = CacheUtils.get(appId))); time -= 700L) {
                    Thread.sleep(700L);
                }
                if (time >= 0L) return token;
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u94f6\u884ctoken\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42\u3002", (String)"TokenService_1", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error(String.format("\u83b7\u53d6%s\u7684token\u5f02\u5e38", appId), (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6token\u51fa\u73b0\u5f02\u5e38\u3002", (String)"TokenService_2", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            logger.info("\u83b7\u53d6\u7f13\u5b58\u4e2d\u7684token\uff1a{}", (Object)token);
        }
        return token;
    }

    public String getBankVersion() {
        return "ZSB_OPA";
    }

    public static String getTokenFromBank(String appId) {
        try {
            GetTokenIn tokenIn = new GetTokenIn();
            tokenIn.setTraceno(Sequence.genSequence());
            GetTokenOut tokenOut = ServiceBean.getService((String)SdkInit.getTenantKey()).getToken(tokenIn);
            String statusCode = tokenOut.getResultcode();
            String statusDesc = tokenOut.getResultdesc();
            if (!"000000".equalsIgnoreCase(statusCode)) {
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)statusCode, (String)statusDesc));
            }
            String token = tokenOut.getToken();
            logger.info("{}\u83b7\u53d6token\uff1a{}", new Object[]{appId, token});
            return token;
        }
        catch (SdkException e) {
            throw EBExceiptionUtil.serviceException((String)SdkInit.sdkError(e), (Throwable)e);
        }
    }

    public static void clearToken(String error) {
        if (StringUtils.isEmpty((String)error)) {
            error = "";
        }
        if (error.contains(TOKEN_ERROR)) {
            TokenService.getInstance().clearToken();
        }
    }

    public void clearToken() {
        String appId = RequestContextUtils.getBankParameterValue((String)ZsbOpaMetaDataImpl.appid);
        CacheUtils.delete(appId);
    }

    public static void clearToken(SdkException e) {
        if (StringUtils.isNotEmpty((String)e.getErrorParams()) && e.getErrorParams().contains(TOKEN_ERROR)) {
            TokenService.getInstance().clearToken();
        }
    }
}

