/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdnxs.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Packer;
import kd.ebg.aqap.banks.gdnxs.dc.services.utils.GDNXS_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        String accNo = bankBalanceRequest.getAcnt().getAccNo();
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)GDNXS_Packer.buildHead(this.getBizCode(), Sequence.gen18Sequence()));
        Element body = new Element("Body");
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)list, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = GDNXS_Parser.parserCommonInfo(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element list = resBody.getChild("List");
        List map = list.getChildren("Map");
        if (map != null && !map.isEmpty()) {
            for (Element element : map) {
                BalanceInfo balanceInfo = new BalanceInfo();
                String accNo = JDomUtils.getChildText((Element)element, (String)"AcNo");
                this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), accNo);
                String currency = JDomUtils.getChildText((Element)element, (String)"Currency");
                this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currency);
                this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
                String balance = element.getChildText("Balance");
                String availBal = element.getChildText("AvailBal");
                this.setAvailableBalance(balanceInfo, balance);
                this.setCurrentBalance(balanceInfo, availBal);
                balanceInfos.add(balanceInfo);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u6ca1\u6709\u8fd4\u56de\u62a5\u6587\u4f53LIST\u3002", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]));
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"2.4.1.2\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\uff08\u4ea4\u6613\u7801B2EActBalQry\uff09", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-gdnxs-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/B2EActBalQry.do?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("userPassword")).append("&SIGDATA=0");
        factory.setUri(sb.toString());
    }
}

