/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.services.payment.batch;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.services.login.LoginUtils;
import kd.ebg.aqap.banks.cexim.dc.services.proxy.FileDownLoad;
import kd.ebg.aqap.banks.cexim.dc.util.CEXIMDCBankResponse;
import kd.ebg.aqap.banks.cexim.dc.util.CommonPacker;
import kd.ebg.aqap.banks.cexim.dc.util.CommonParser;
import kd.ebg.aqap.banks.cexim.dc.util.FileUtils;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.aqap.banks.cexim.dc.util.PaymentUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryBatchDetailPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBatchDetailPayImpl.class);

    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest request) {
        LoginUtils.login();
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.createSystemHead(this.getBizCode());
        root.addContent((Content)headr);
        Element req = CommonPacker.packPayComEntity(info.getBankBatchSeqId());
        body.addContent((Content)req);
        JDomExtUtils.addChildCDData(req, "CstPty_Py_Jrnl_No", PaymentUtils.getKDByBatch(info));
        return JDomExtUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CEXIMDCBankResponse bankResponse = CommonParser.getFrontResponse(responseStr);
        if (!bankResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"QueryBatchDetailPayImpl_0", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), bankResponse.getResponseCode() + bankResponse.getResponseMessage()));
        }
        responseStr = bankResponse.getBankMsg();
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        List paymentInfos = request.getPaymentInfos();
        CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\uff0c\u6216\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7ed3\u679c\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"QueryBatchDetailPayImpl_1", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return ebBankPayResponse;
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String recNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        if (!"0".equalsIgnoreCase(recNum)) {
            List resultList = response.getChildren("FILE_LIST_PACK");
            for (Element element : resultList) {
                String fileNum = element.getChildText("FILE_NUM");
                List fileInfoList = element.getChildren("FILE_INFO");
                this.logger.info("\u67e5\u8be2\u5230\u6587\u4ef6\u4e2a\u6570:{}", (Object)fileNum);
                this.downloadAndParse(fileInfoList, paymentInfos);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\u3002", (String)"QueryBatchDetailPayImpl_2", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (String)"", (String)"");
        }
        ebBankPayResponse.setPaymentInfos(paymentInfos);
        return ebBankPayResponse;
    }

    private void downloadAndParse(List<Element> fileInfoList, List<PaymentInfo> paymentInfos) {
        HashMap<String, CEXIMDCBankResponse> map = new HashMap<String, CEXIMDCBankResponse>(1);
        for (Element fileElement : fileInfoList) {
            String fileName = fileElement.getChildText("FILE_NAME");
            String msgSmy = fileElement.getChildText("Msg_Smy");
            FileDownLoad fileDownLoad = new FileDownLoad();
            String fileString = fileDownLoad.doBiz(fileName);
            String[] records = fileString.split(FileUtils.LINESEPARTOR);
            this.logger.info("{}\u83b7\u53d6\u5230\u8bb0\u5f55\u6761\u6570\uff1a{}", new Object[]{fileName, records.length});
            for (int i = 0; i < records.length; ++i) {
                String[] splits = records[i].split(FileUtils.SEPARATOR);
                for (int j = 0; j < splits.length; ++j) {
                    String resultCode = splits[56];
                    String errorMsg = splits[57];
                    String btchDtlId = splits[0];
                    CEXIMDCBankResponse response = new CEXIMDCBankResponse();
                    response.setResponseMessage(errorMsg);
                    response.setResponseCode(resultCode);
                    map.put(btchDtlId, response);
                }
            }
        }
        for (PaymentInfo info : paymentInfos) {
            CEXIMDCBankResponse resultCode = (CEXIMDCBankResponse)((Object)map.get(info.getBankDetailSeqId()));
            if (null == resultCode) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u7ed3\u679c\u660e\u7ec6", (String)"QueryBatchDetailPayImpl_3", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (String)"", (String)"");
                continue;
            }
            if ("1".equals(resultCode.getResponseCode())) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)resultCode.getResponseCode(), (String)"");
                continue;
            }
            if ("3".equals(resultCode.getResponseCode())) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)resultCode.getResponseCode(), (String)resultCode.getBankMsg());
                continue;
            }
            if ("2".equals(resultCode.getResponseCode())) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)resultCode.getResponseCode(), (String)resultCode.getBankMsg());
                continue;
            }
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)resultCode.getResponseCode(), (String)resultCode.getBankMsg());
        }
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "P1CMSETB8";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0b\u8f7d\u4eba\u6c11\u5e01\u6279\u91cf\u4ed8\u6b3e\u4ea4\u6613\u7ed3\u679c\u660e\u7ec6\u4fe1\u606f", (String)"QueryBatchDetailPayImpl_4", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]);
    }
}

