/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.util.CEXIMDCBankResponse;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Element;

public class CommonParser {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(CommonParser.class);

    public static CEXIMDCBankResponse getFrontResponse(String rspStr) {
        CEXIMDCBankResponse response = new CEXIMDCBankResponse();
        Element root = JDomUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element header = JDomUtils.getChildElement((Element)root, (String)"header");
        String returnCode = JDomUtils.getChildText((Element)header, (String)"returnCode");
        String returnMsg = JDomUtils.getChildText((Element)header, (String)"returnMsg");
        String exception = JDomUtils.getChildText((Element)header, (String)"exception");
        response.setResponseCode(returnCode);
        response.setResponseMessage(returnMsg);
        if (!"0000".equalsIgnoreCase(returnCode)) {
            logger.info("\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5931\u8d25\u3002");
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
            Element body = JDomUtils.getChildElement((Element)root, (String)"body");
            String bankMsg = "";
            try {
                byte[] content = Base64.decodeBase64((String)JDomUtils.getChildText((Element)body, (String)"bankMsg"));
                bankMsg = new String(content, EBContext.getContext().getCharsetName());
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u8282\u70b9bankMsg\u53d1\u751f\u5f02\u5e38\u3002", (String)"CommonParser_0", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (Throwable)e);
            }
            response.setBankMsg(bankMsg);
            logger.info("\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u62a5\u6587\uff1a" + bankMsg);
        }
        return response;
    }

    public static CEXIMDCBankResponse getBankPreResponse(String rspStr) {
        CEXIMDCBankResponse response = new CEXIMDCBankResponse();
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element header = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String statusCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_TX_STATUS");
        String bankCode = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_CODE");
        String bankMsg = JDomExtUtils.getChildText((Element)header, (String)"SYS_RESP_DESC");
        response.setResponseCode(bankCode);
        response.setResponseMessage(bankMsg);
        response.setBankMsg(bankMsg);
        if ("01".equalsIgnoreCase(statusCode)) {
            response.setSuccess(false);
        } else {
            response.setSuccess(true);
        }
        Element tranResponse = JDomExtUtils.getChildElement((Element)header, (String)"tran_response");
        if (null != tranResponse) {
            String status = JDomExtUtils.getChildText((Element)tranResponse, (String)"status");
            if ("COMPLETE".equalsIgnoreCase(status)) {
                response.setPaySuccess(true);
            } else {
                response.setUnkown(true);
            }
        } else {
            response.setUnkown(true);
        }
        String STS_TRACE_ID = JDomExtUtils.getChildText((Element)header, (String)"STS_TRACE_ID");
        String TOTAL_PAGE = JDomExtUtils.getChildText((Element)header, (String)"TOTAL_PAGE");
        if (StringUtils.isNotEmpty((String)STS_TRACE_ID)) {
            response.setStsTraceId(STS_TRACE_ID);
        }
        if (StringUtils.isNotEmpty((String)TOTAL_PAGE)) {
            response.setTotalPage(TOTAL_PAGE);
        }
        return response;
    }

    public static Map<String, CEXIMDCBankResponse> getParseredPayStatus(List<Element> reslutList) {
        HashMap<String, CEXIMDCBankResponse> parseredMap = new HashMap<String, CEXIMDCBankResponse>(16);
        for (Element node : reslutList) {
            String sequence = JDomExtUtils.getChildText((Element)node, (String)"CstPty_Py_Jrnl_No");
            String resultCode = JDomExtUtils.getChildText((Element)node, (String)"CshMgt_Txn_Rslt_Cd");
            String errorMsg = JDomExtUtils.getChildText((Element)node, (String)"Err_Inf");
            String errorCode = JDomExtUtils.getChildText((Element)node, (String)"CshMgt_Err_Cd");
            CEXIMDCBankResponse response = new CEXIMDCBankResponse();
            response.setBankMsg(errorMsg);
            response.setResponseCode(resultCode);
            response.setResponseMessage(errorMsg);
            parseredMap.put(sequence, response);
        }
        return parseredMap;
    }
}

