/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hzyq.dc.service.payment.pay;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.HZYQ_Packer;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.TCommon;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.Utils;
import kd.ebg.aqap.banks.hzyq.dc.service.payment.pay.CompanyPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CompanyPayQueryImpl.class);
    private static final String tradeName = "BY0003";

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo info) {
        return info.getImplClassName().equals(CompanyPayImpl.class.getName());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = Utils.listToArray(request.getPaymentInfos());
        Element root = new Element("body");
        Element head = HZYQ_Packer.createHZYQRoot(tradeName);
        JDomUtils.addChild((Element)root, (Element)head);
        Element map = new Element("map");
        JDomUtils.addChild((Element)map, (String)"erpReqNo", (String)paymentInfos[0].getBankDetailSeqId());
        JDomUtils.addChild((Element)map, (String)"billCode", (String)"");
        JDomUtils.addChild((Element)map, (String)"erpBatchNo", (String)paymentInfos[0].getBatchSeqId());
        JDomUtils.addChild((Element)root, (Element)map);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String rspmsg = HZYQ_Packer.headnumber(tradeName) + RspMsg;
        return TCommon.createCommonMsg(rspmsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        PaymentInfo[] paymentInfos = Utils.listToArray(request.getPaymentInfos());
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = JDomUtils.getChildElement((Element)root, (String)"head");
        String erpSysCode = JDomUtils.getChildText((Element)head, (String)"erpSysCode");
        String custNo = JDomUtils.getChildText((Element)head, (String)"custNo");
        String tradeName = JDomUtils.getChildText((Element)head, (String)"tradeName");
        String retCode = JDomUtils.getChildText((Element)head, (String)"retCode");
        String retMsg = JDomUtils.getChildText((Element)head, (String)"retMsg");
        Element loopData = JDomUtils.getChildElement((Element)root, (String)"loopData");
        if (loopData == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684xml\u9519\u8bef\uff0cloopData\u8282\u70b9\u4e0d\u5b58\u5728\u3002", (String)"CompanyPayQueryImpl_0", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
        }
        List list = loopData.getChildren("row");
        if (list == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684xml\u9519\u8bef\uff0crow\u8282\u70b9\u4e0d\u5b58\u5728\u3002", (String)"CompanyPayQueryImpl_1", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
        }
        for (int i = 0; i < list.size(); ++i) {
            Element row = (Element)list.get(i);
            String erpReqNo = row.getChildTextTrim("erpReqNo");
            String erpBatchNo = row.getChildTextTrim("erpBatchNo");
            String billCode = row.getChildTextTrim("billCode");
            String payeeAccNo = row.getChildTextTrim("payeeAccNo");
            String payMoney = row.getChildTextTrim("payMoney");
            String payState = row.getChildTextTrim("payState");
            String payMsg = row.getChildTextTrim("payMsg");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)erpReqNo);
            if (null == paymentInfo) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u610f\u5916\u7684\u4ed8\u6b3e\u987a\u5e8f\u53f7:erpReqNo=%s", (String)"CompanyPayQueryImpl_13", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), erpReqNo));
            }
            log.info("###\u672c\u6b21\u4ed8\u6b3e\u7ed3\u679c\u67e5\u8be2\u67e5\u8be2\u8fd4\u56de\u72b6\u6001" + payState);
            if ("00".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u6210\u529f", (String)"CompanyPayQueryImpl_3", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"CompanyPayQueryImpl_4", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
                continue;
            }
            if ("01".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u5f85\u63d0\u4ea4", (String)"CompanyPayQueryImpl_5", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)payMsg);
                continue;
            }
            if ("02 ".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u6d41\u7a0b\u4e2d", (String)"CompanyPayQueryImpl_6", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)payMsg);
                continue;
            }
            if ("03".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u7b49\u5f85\u94f6\u884c\u7ed3\u679c", (String)"CompanyPayQueryImpl_7", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)payMsg);
                continue;
            }
            if ("95".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u5df2\u5220\u9664", (String)"CompanyPayQueryImpl_8", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)payMsg);
                continue;
            }
            if ("96".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u5df2\u6253\u56de", (String)"CompanyPayQueryImpl_9", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)payMsg);
                continue;
            }
            if ("97".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u4e0d\u5b58\u5728", (String)"CompanyPayQueryImpl_10", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)payMsg);
                continue;
            }
            if ("98".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25", (String)"CompanyPayQueryImpl_11", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)payMsg);
                continue;
            }
            if ("99".equals(payState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u5176\u4ed6\u72b6\u6001", (String)"CompanyPayQueryImpl_12", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)payMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u5176\u4ed6\u72b6\u6001", (String)"CompanyPayQueryImpl_12", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)payState, (String)payMsg);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String uri = "";
        try {
            uri = RequestContextUtils.getBankParameterValue((String)"uri");
        }
        catch (Exception e) {
            log.error("\u676d\u5dde\u94f6\u4f01\u83b7\u53d6uri\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u676d\u5dde\u8d22\u653f\u7cfb\u7edfURI\u8def\u5f84:{}", (Object)uri);
        factory.setUri(uri);
    }
}

