/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bxw.opa.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xwbank.sdk.entity.acctranshistoryquery.AccTransHistoryQueryInfo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bxw.opa.services.utils.XWBResponse;
import kd.ebg.aqap.banks.bxw.opa.services.utils.XWUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        String customID = EBContext.getContext().getCustomID();
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(8);
        try {
            String appID = RequestContextUtils.getBankParameterValue((String)"appID");
            LocalDate startDate = request.getStartDate();
            LocalDate endDate = request.getEndDate();
            AccTransHistoryQueryInfo accTransHistoryQueryInfo = new AccTransHistoryQueryInfo();
            accTransHistoryQueryInfo.setAppId(appID);
            accTransHistoryQueryInfo.setBASE_ACCT_NO(request.getAcnt().getAccNo());
            accTransHistoryQueryInfo.setCCY(request.getBankCurrency());
            accTransHistoryQueryInfo.setSTART_DATE(startDate.format(DateTimeFormatter.BASIC_ISO_DATE));
            accTransHistoryQueryInfo.setEND_DATE(endDate.format(DateTimeFormatter.BASIC_ISO_DATE));
            accTransHistoryQueryInfo.setSTART_SEQ_NO("1");
            XWBResponse xwbResponse = XWUtil.send(accTransHistoryQueryInfo, customID);
            if (!xwbResponse.isSuccess()) {
                throw EBExceiptionUtil.serviceException((String)xwbResponse.getResponseMessage());
            }
            JSONObject data = xwbResponse.getData();
            JSONArray tran_hist_detail = data.getJSONArray("TRAN_HIST_DETAIL");
            if (tran_hist_detail == null || tran_hist_detail.isEmpty()) {
                return new EBBankDetailResponse(result);
            }
            for (int i = 0; i < tran_hist_detail.size(); ++i) {
                DetailInfo detailInfo = new DetailInfo();
                JSONObject detail = tran_hist_detail.getJSONObject(i);
                String tfr_acct_no = detail.getString("TFR_ACCT_NO");
                String tfr_acct_name = detail.getString("TFR_ACCT_NAME");
                String actual_bal_amt = detail.getString("ACTUAL_BAL_AMT");
                String cr_dr_maint_ind = detail.getString("CR_DR_MAINT_IND");
                String tran_amt = detail.getString("TRAN_AMT");
                String tran_date = detail.getString("TRAN_DATE");
                String tran_time = detail.getString("TRAN_TIME");
                String narrative = detail.getString("NARRATIVE");
                String seq_no = detail.getString("SEQ_NO");
                detailInfo.setAccNo(request.getAcnt().getAccNo());
                detailInfo.setAccName(request.getAcnt().getAccName());
                detailInfo.setOppAccNo(tfr_acct_no);
                detailInfo.setOppAccName(tfr_acct_name);
                detailInfo.setBalance(new BigDecimal(actual_bal_amt));
                if ("C".equalsIgnoreCase(cr_dr_maint_ind)) {
                    detailInfo.setCreditAmount(new BigDecimal(tran_amt));
                    detailInfo.setDebitAmount(BigDecimal.ZERO);
                } else {
                    detailInfo.setDebitAmount(new BigDecimal(tran_amt));
                    detailInfo.setCreditAmount(BigDecimal.ZERO);
                }
                detailInfo.setCurrency(request.getBankCurrency());
                LocalDateTime tTime = LocalDateTime.parse(tran_date + tran_time, DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss"));
                LocalDate tDate = tTime.toLocalDate();
                detailInfo.setTransDate(tDate);
                detailInfo.setTransTime(tTime);
                detailInfo.setExplanation(narrative);
                JSONObject jsonMap = new JSONObject();
                jsonMap.put("seq_no", (Object)seq_no);
                detailInfo.setJsonMap(jsonMap.toJSONString());
                result.add(detailInfo);
            }
            return new EBBankDetailResponse(result);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-bxw-opa", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "AccTransHistoryQuery";
    }

    public String getBizDesc() {
        return null;
    }
}

