/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.mservice.boot.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FrameworkInfoMap<K, V>
extends HashMap<K, String> {
    private final Map<K, ArrayList<String>> slicesMap;
    private final int chunkSize;

    public FrameworkInfoMap(int chunkSize) {
        this.chunkSize = chunkSize;
        this.slicesMap = new HashMap<K, ArrayList<String>>(1);
    }

    @Override
    public String get(Object key) {
        ArrayList<String> slices = this.slicesMap.get(key);
        return this.assemble(slices);
    }

    @Override
    public String put(K key, String value) {
        ArrayList<String> oldVal = this.slicesMap.put(key, this.slice(value));
        return this.assemble(oldVal);
    }

    private ArrayList<String> slice(String value) {
        int capacity = (value.length() + this.chunkSize - 1) / this.chunkSize;
        ArrayList<String> slices = new ArrayList<String>(capacity);
        while (value.length() > this.chunkSize) {
            slices.add(value.substring(0, this.chunkSize));
            value = value.substring(this.chunkSize);
        }
        slices.add(value);
        return slices;
    }

    private String assemble(ArrayList<String> slices) {
        if (Objects.isNull(slices)) {
            return null;
        }
        return String.join((CharSequence)"", slices);
    }
}

