/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.dc.service.payment.individual.authorize;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Packer;
import kd.ebg.aqap.banks.bocom.dc.service.BOCOM_DC_Parser;
import kd.ebg.aqap.banks.bocom.dc.service.payment.BOCOMUseConvertor;
import kd.ebg.aqap.banks.bocom.dc.service.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SlowPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "330010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u3001\u62a5\u9500\u5dee\u65c5\u8d39\uff08330010\uff09 --\u975e\u5b9e\u65f6\u3001\u7f51\u94f6\u5ba1\u6838", (String)"SlowPayImpl_0", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return false;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element root = BOCOM_DC_Packer.packRoot(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        String busiType = BOCOMUseConvertor.convert2BOCOMType(this.getBizCode(), paymentInfos[0]);
        JDomUtils.addChild((Element)body, (String)"type", (String)busiType);
        JDomUtils.addChild((Element)body, (String)"selsec_flg", (String)BankBusinessConfig.getSelectFlag());
        JDomUtils.addChild((Element)body, (String)"pay_month", (String)new SimpleDateFormat("yyyyMM").format(new Date()));
        boolean needSubSummary = BankBusinessConfig.isNeedSubSummary();
        String exp = paymentInfos[0].getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay() && paymentInfos[0].is2Merge()) {
            PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo[])paymentInfos);
            exp = BizNoUtil.cont((String)paymentInfos[0].getBankBatchSeqId(), (String)exp);
        } else if (BankBusinessConfig.isAddKDFlagToPay() && !paymentInfos[0].is2Merge() && paymentInfos.length == 1) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
            exp = BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqId(), (String)exp);
        }
        JDomUtils.addChild((Element)body, (String)"summary", (String)PaymentUtil.substringChinese((boolean)needSubSummary, (String)exp, (int)60, (String)RequestContextUtils.getCharset()));
        String busiNo = BankBusinessConfig.getPayrollNo(paymentInfos[0].getAccNo(), busiType);
        if (StringUtils.isEmpty((String)busiNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u534f\u8bae\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u8d26\u53f7\u9644\u52a0\u5c5e\u6027\u7ef4\u62a4\u3002", (String)"SlowPayImpl_1", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"busi_no", (String)busiNo);
        if (paymentInfos[0].is2Merge()) {
            JDomUtils.addChild((Element)body, (String)"mailflg", (String)"Y");
        } else {
            JDomUtils.addChild((Element)body, (String)"mailflg", (String)"N");
        }
        Element tran = JDomUtils.addChild((Element)body, (String)"tran");
        BigDecimal totalAmount = new BigDecimal("0");
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element rcd = JDomUtils.addChild((Element)tran, (String)"rcd");
            JDomUtils.addChild((Element)rcd, (String)"card_no", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)rcd, (String)"acname", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)rcd, (String)"card_flag", (String)"0");
            BigDecimal amount = paymentInfos[i].getAmount();
            totalAmount = totalAmount.add(amount);
            JDomUtils.addChild((Element)rcd, (String)"amt", (String)amount.toString());
            JDomUtils.addChild((Element)rcd, (String)"busino", (String)paymentInfos[i].getBankDetailSeqId());
        }
        JDomUtils.addChild((Element)body, (String)"sum", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)body, (String)"sum_amt", (String)totalAmount.toString());
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u63d0\u4ea4\u6210\u529f", (String)"SlowPayImpl_2", (String)"ebg-aqap-banks-bocom-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

