/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jshb.dc.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jshb.dc.utils.ParserUtil;
import kd.ebg.aqap.banks.jshb.dc.utils.TCommon;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) {
        Element root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)RequestContextUtils.getCharset());
        BankResponse rsp = ParserUtil.parseResponeCode(root);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s,%2$s", (String)"TodayBalanceParser_2", (String)"ebg-aqap-banks-jshb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        EBBankBalanceResponse balanceRsp = new EBBankBalanceResponse();
        BalanceInfo balanceInfo = new BalanceInfo();
        String acno = body.getChildTextTrim("acno");
        String balance = body.getChildTextTrim("balance");
        String use_balance = body.getChildTextTrim("use_balance");
        if (!rqst.getAcnt().getAccNo().equals(acno)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25,\u539f\u56e0:\u8bf7\u6c42\u8d26\u53f7\u4e0e\u94f6\u884c\u54cd\u5e94\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceParser_1", (String)"ebg-aqap-banks-jshb-dc", (Object[])new Object[0]));
        }
        balanceInfo.setBankAcnt(rqst.getAcnt());
        balanceInfo.setBankCurrency(rqst.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        if (!StringUtils.isEmpty((String)balance)) {
            balanceInfo.setCurrentBalance(new BigDecimal(balance));
        }
        if (!StringUtils.isEmpty((String)use_balance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
        }
        ArrayList<BalanceInfo> list = new ArrayList<BalanceInfo>(16);
        list.add(balanceInfo);
        balanceRsp.setBalances(list);
        return balanceRsp;
    }
}

