/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jshb.dc.transfer.salary;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jshb.dc.proxy.FileUploadUtil;
import kd.ebg.aqap.banks.jshb.dc.utils.Packer;
import kd.ebg.aqap.banks.jshb.dc.utils.TCommon;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayPacker.class);

    public String packPay(PaymentInfo[] paymentInfos) {
        Element root = Packer.buildHead(paymentInfos[0].getBankBatchSeqId(), "300002");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)"0");
        String fileName = paymentInfos[0].getBankBatchSeqId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"amt");
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)"");
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfos[0].getExplanation());
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        StringBuilder content = new StringBuilder();
        content.append("acno|cur_code|acname|cardflag|amt|postscript|\r\n");
        BigDecimal totalamount = new BigDecimal("0.00");
        this.logger.info("paymentInfos.length:" + paymentInfos.length);
        for (int i = 0; i < paymentInfos.length; ++i) {
            content.append(paymentInfos[i].getIncomeAccNo()).append("|").append(paymentInfos[i].getCurrency()).append("|").append(paymentInfos[i].getIncomeAccName()).append("|").append("|").append(paymentInfos[i].getAmount()).append("|").append(paymentInfos[i].getExplanation()).append("|\r\n");
            totalamount = totalamount.add(paymentInfos[i].getAmount());
        }
        JDomUtils.getChildElement((Element)body, (String)"amt").addContent(totalamount.toPlainString());
        this.logger.info("[\u4ee3\u53d1\u5de5\u8d44]\u6587\u4ef6\u540d\uff1a" + fileName);
        this.logger.info("[\u4ee3\u53d1\u5de5\u8d44]\u6587\u4ef6\u5185\u5bb9\uff1a" + content);
        try {
            FileUploadUtil fileUtil = new FileUploadUtil();
            fileUtil.setFileContent(content.toString());
            fileUtil.doBiz(fileName);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"###[\u4ee3\u53d1\u5de5\u8d44]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (String)"PayPacker_0", (String)"ebg-aqap-banks-jshb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return TCommon.createCommonMsg(requestMessage);
    }
}

