/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);
    public static final int STEPVALUE = 100;

    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest request) {
        Element root = ZJRC_DC_Packer.getCommonHeader("200002", Sequence.genSequence());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        JDomUtils.addChild((Element)reqBody, (String)"accountNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)reqBody, (String)"currencyType", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)reqBody, (String)"cashFlag", (String)"1");
        JDomUtils.addChild((Element)reqBody, (String)"beginDate", (String)ZJRC_DC_Packer.formatDate(request.getStartDate()));
        JDomUtils.addChild((Element)reqBody, (String)"endDate", (String)ZJRC_DC_Packer.formatDate(request.getEndDate()));
        if (Objects.equals(this.getCurrentPage(), "0")) {
            this.setCurrentPage("1");
        }
        JDomUtils.addChild((Element)reqBody, (String)"page", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)reqBody, (String)"showNum", (String)"100");
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (null == bankResponse.getResponseCode() || !bankResponse.getResponseCode().equalsIgnoreCase("0000")) {
            if ("503".equals(bankResponse.getResponseCode()) && PropertiesConstants.getValue((String)"CORE0005").equals(bankResponse.getResponseMessage())) {
                int tage = Integer.parseInt(this.getCurrentPage()) + 1;
                this.setCurrentPage(tage);
                this.setLastPage(true);
                return new EBBankDetailResponse(detailInfos);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff0c%s\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
        String page = JDomUtils.getChildTextNotNull((Element)resBody, (String)"page");
        int pageNum = 0;
        if (StringUtils.isNotEmpty((String)page)) {
            pageNum = Integer.parseInt(page) + 1;
        }
        this.setCurrentPage(pageNum);
        String totalStr = JDomUtils.getChildTextNotNull((Element)resBody, (String)"totalNumber");
        if ("0".equals(totalStr)) {
            this.setLastPage(true);
            this.log.info("\u6ca1\u6709\u660e\u7ec6\u8fd4\u56de");
            return new EBBankDetailResponse(detailInfos);
        }
        int totalNum = 0;
        if (StringUtils.isEmpty((String)totalStr)) {
            this.setLastPage(true);
        } else {
            totalNum = Integer.parseInt(totalStr);
            if (pageNum * 100 >= totalNum) {
                this.setLastPage(true);
            } else {
                this.setLastPage(false);
            }
        }
        Element transDetailList = JDomUtils.getChildElement((Element)resBody, (String)"transDetailList");
        List rows = transDetailList.getChildren("row");
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < rows.size(); ++i) {
            String lastArray;
            String accountNo = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"accountNo");
            if (null == accountNo || !accountNo.equals(request.getAcnt().getAccNo())) {
                this.log.info(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7[%1$s]\u548c\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\uff0c\u88ab\u8fc7\u6ee4\u7684\u660e\u7ec6", (String)"DetailImpl_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), accountNo));
                continue;
            }
            String transferTime = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"transferTime");
            String currencyType = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"currencyType");
            String cashFlag = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"cashFlag");
            String transferSum = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"transferSum");
            String balance = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"balance");
            String loanFlag = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"loanFlag");
            String otherAccNo = JDomUtils.getChildTextNotNull((Element)((Element)rows.get(i)), (String)"otherAccNo");
            String recAccountName = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"recAccountName");
            String remark = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"remark");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(accountNo);
            detailInfo.setBalance(new BigDecimal(balance));
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH.mm.ss");
            String[] arrays = transferTime.split("\\.");
            String formatDateStr = transferTime;
            if (arrays.length > 2 && (lastArray = arrays[arrays.length - 1]).length() > 2) {
                formatDateStr = transferTime.substring(0, transferTime.lastIndexOf("."));
            }
            LocalDateTime dateTime = LocalDateTime.parse(formatDateStr, dateTimeFormatter);
            detailInfo.setTransTime(dateTime);
            detailInfo.setTransDate(LocalDate.parse(JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"transferDate"), ZJRC_DC_Packer.DATE_FORMATTER));
            detailInfo.setCurrency(currencyType);
            detailInfo.setOppAccNo(otherAccNo);
            detailInfo.setOppAccName(recAccountName);
            if (loanFlag.equals("1")) {
                detailInfo.setDebitAmount(new BigDecimal(transferSum));
                detailInfo.setCreditAmount(new BigDecimal("0"));
            } else {
                detailInfo.setDebitAmount(new BigDecimal("0"));
                detailInfo.setCreditAmount(new BigDecimal(transferSum));
            }
            detailInfo.setExplanation(remark);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData((Element)rows.get(i));
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"transferFlowNo"));
            String transferFlowNo = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"transferFlowNo");
            String subTranFlow = JDomUtils.getChildText((Element)((Element)rows.get(i)), (String)"subTranFlow");
            String transferDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accountNo, transferDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            detailInfos.add(detailInfo);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "200002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_3", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
    }
}

