/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.opa.services.balance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.opa.utils.CommonUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        EBBankBalanceResponse result;
        try {
            String requestStr = this.pack(request);
            Preconditions.checkNotNull((Object)requestStr, (Object)ResManager.loadKDString((String)"\u6253\u5305\u540e\u5f85\u53d1\u9001\u7684\u6570\u636e\u4e0d\u80fd\u4e3anull", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
            String responseStr = new CommonUtil().sendToBank(this.getBizCode(), requestStr);
            result = this.parse(request, responseStr);
        }
        catch (Exception var14) {
            this.logger.error("\u67e5\u8be2\u5b9e\u65f6\u4f59\u989d\u5931\u8d25", (Throwable)var14);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5b9e\u65f6\u4f59\u989d\u5931\u8d25", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]), (Throwable)var14);
        }
        return result;
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("serialNo", (Object)Sequence.gen18Sequence());
        jsonObject.put("cid", (Object)EBContext.getContext().getParameter().getBankParameter("cust_no"));
        jsonObject.put("acctNo", (Object)((BankAcnt)bankBalanceRequest.getBankAcntList().get(0)).getAccNo());
        return jsonObject.toJSONString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        String code = jsonObject.getString("code");
        String msg = jsonObject.getString("msg");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)msg);
        }
        BankAcnt bankAcnt = (BankAcnt)bankBalanceRequest.getBankAcntList().get(0);
        String acctNo = jsonObject.getString("acctNo");
        if (!bankAcnt.getAccNo().equals(acctNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7[%1$s]\u4e0e\u8fd4\u56de\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]), bankAcnt.getAccNo(), acctNo));
        }
        ArrayList<BalanceInfo> balanceList = new ArrayList<BalanceInfo>();
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(bankAcnt);
        balanceInfo.setCurrentBalance(jsonObject.getBigDecimal("balAmt"));
        balanceInfo.setAvailableBalance(jsonObject.getBigDecimal("availBal"));
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
        balanceList.add(balanceInfo);
        return new EBBankBalanceResponse(balanceList);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "/api/dcfirmSAAS/queryBalanceAmount";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b9e\u65f6\u4f59\u989d", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
    }
}

