/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.ecny.service.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.ecny.service.Packer;
import kd.ebg.aqap.banks.boc.ecny.service.Parser;
import kd.ebg.aqap.banks.boc.ecny.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.ecny.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(BankBalanceRequest request) {
        return true;
    }

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList balanceInfos = new ArrayList(1);
        try {
            EBBankBalanceResponse response = this.doBiz(request);
            balanceInfos.addAll(response.getBalances());
        }
        catch (EBServiceException e) {
            throw new EBServiceException((Throwable)e);
        }
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader(token, "b2e0670");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0670-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0670-rq");
            JDomUtils.addChild((Element)rq, (String)"walletid", (String)request.getAcnt().getAccNo());
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        BankAcnt acnt = request.getHeader().getAcnt();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0670-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25:%s\u3002", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]), rspcod + rspmsg));
        }
        Element rs = trn.getChild("b2e0670-rs");
        Element another_status = rs.getChild("status");
        String another_rspcod = another_status.getChildTextTrim("rspcod");
        String another_rspmsg = another_status.getChildTextTrim("rspmsg");
        if (!"B001".equalsIgnoreCase(another_rspcod)) {
            throw EBExceiptionUtil.serviceException((String)("balance query error:" + another_rspcod + another_rspmsg));
        }
        Element walletinfo = rs.getChild("walletinfo");
        String bokbal = walletinfo.getChildTextTrim("walletbal");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balances.add(balanceInfo);
        if (StringUtils.isEmpty((CharSequence)bokbal)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]));
        }
        balanceInfo.setCurrentBalance(new BigDecimal(bokbal));
        balanceInfo.setBankAcnt(acnt);
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "Simon";
    }

    public String getBizCode() {
        return "b2e0670";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eca\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-boc-ecny", (Object[])new Object[0]);
    }
}

