/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayDepositBalBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DepositBalanceImpl
extends AbstractBalanceImpl
implements ITodayDepositBalBalance {
    public String pack(BankBalanceRequest request) {
        BankAcnt bankAcnt = (BankAcnt)request.getBankAcntList().get(0);
        Element root = ICBC_CMP_Packer.createICBCCMPRoot("GQMIDHLIST");
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)in, (String)"QueryType", (String)"2");
        JDomUtils.addChild((Element)in, (String)"QueryMode", (String)"1");
        JDomUtils.addChild((Element)in, (String)"NextTag", (String)"");
        JDomUtils.addChild((Element)in, (String)"QueryCurr", (String)request.getBankCurrency());
        String encoding = EBContext.getContext().getCharsetName();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, "GQMIDHLIST", "0.0.1.0");
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        EBContext context;
        String encoding;
        String retMsg = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        Element root = JDomUtils.string2Root((String)retMsg, (String)(encoding = (context = EBContext.getContext()).getCharsetName()));
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2\u5931\u8d25%s", (String)"DepositBalanceImpl_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), StrUtil.join((String)" ", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage()));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        Element out = eb.getChild("out");
        String currType = out.getChildTextTrim("CurrType");
        balanceInfo.setBankCurrency(StringUtils.isEmpty((String)currType) ? bankBalanceRequest.getBankCurrency() : currType);
        List list = out.getChildren("rd");
        if (list.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5de5\u884c\u4f59\u989d\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\u683c\u5f0f\u9519\u8bef,\u4e0d\u542brd\u5143\u7d20", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        if (list.size() == 1) {
            Element rd = (Element)list.get(0);
            String loanTotalAmt = rd.getChildTextTrim("LoanTotalAmt");
            balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
            balanceInfo.setDepositBalance(ParserUtils.convertCentStr2Yuan((String)loanTotalAmt));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GQMIDHLIST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2", (String)"DepositBalanceImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        LocalDate today = LocalDate.now();
        boolean matchTime = today.equals(request.getStartDate()) && today.equals(request.getEndDate());
        boolean matchConfig = BankBusinessConfig.isQueryDepositBal(((BankAcnt)request.getBankAcntList().get(0)).getAccNo());
        return matchTime && matchConfig;
    }
}

