/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment.allocation;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.ICBC_CMP_FailErrorCodes;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final String TRANS_CODE = "GQCOLDIS";

    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return TRANS_CODE;
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getImplClassName().equalsIgnoreCase(AllocationPayImpl.class.getName());
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = ICBC_CMP_Packer.createICBCCMPRoot(TRANS_CODE);
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"QryfSeqno", (String)paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)in, (String)"QrySerialNo", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = EBContext.getContext().getCharsetName();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, TRANS_CODE);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        String simplifyRspCode4Cpic = EBContext.getContext().getParameter().getBankParameter("simplifyRspCode4Cpic");
        boolean cpic = "true".equalsIgnoreCase(simplifyRspCode4Cpic);
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        String fSeqno = pub.getChildText("fSeqno");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "";
        bankStatus = cpic ? headRsp.getResponseCode() : "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            if (ICBC_CMP_FailErrorCodes.isFailed(headRsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            }
            return new EBBankPayResponse(paymentInfos);
        }
        Element out = eb.getChild("out");
        if (null == out) {
            if (0 != paymentInfos.size()) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5de5\u884c\u63a5\u6536\u4e86\u6279\u91cf\u4ed8\u6b3e\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u72b6\u6001\u3002", (String)"AllocationQueryPayImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
                return new EBBankPayResponse(paymentInfos);
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        String result = JDomUtils.getChildText((Element)out, (String)"Result");
        if ("7".equalsIgnoreCase(result)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
        } else if ("6".equalsIgnoreCase(result) || "8".equalsIgnoreCase(result)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            if ("B0083".equalsIgnoreCase(headRsp.getResponseCode())) {
                paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u94f6\u4f01\u4e2d\u95f4\u4ef6\u5efa\u8bae\u60a8\u68c0\u67e5\u6536\u6b3e\u8d26\u53f7,\u4ed8\u6b3e\u5931\u8d25\u7684\u539f\u56e0\u53ef\u80fd\u662f:\u5de5\u884c\u7684\u540c\u884c\u652f\u4ed8\u65f6,\u6536\u6b3e\u8d26\u53f7\u586b\u5199\u9519\u8bef", (String)"AllocationQueryPayImpl_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

