/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment.companynew;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_PayParser;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.companynew.CompanyNewQueryPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.CommonUtils;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.ZipUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyNewPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CompanyNewPayImpl.class);
    private static final String transCode = "PAYENT";

    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyNewQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return transCode;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u300a\u652f\u4ed8\u6307\u4ee4\u63d0\u4ea4.xls\u300b\u548c\u300a\u652f\u4ed8\u6307\u4ee4\u67e5\u8be2.xls\u300b\u5206\u522b\u5bf9\u5e94\u4ea4\u6613\u7801PAYENT\u548cQPAYENT\u3002", (String)"CompanyNewPayImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && BankBusinessConfig.isUseZipInterface() && paymentInfo.getIndividual() == false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        BigDecimal totalAmt = new BigDecimal("0.00");
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(transCode, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"OnlBatF", (String)"1");
        if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
            JDomUtils.addChild((Element)in, (String)"SettleMode", (String)"2");
        } else {
            JDomUtils.addChild((Element)in, (String)"SettleMode", (String)"0");
        }
        JDomUtils.addChild((Element)in, (String)"TotalNum", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)in, (String)"TotalAmt", (String)"");
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        IParameter parameter = context.getParameter();
        String signDate4Test = parameter.getBankParameter("signDate4Test");
        boolean isProduct = StrUtil.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS"))));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        StringBuilder rdStr = new StringBuilder();
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            Element rd = new Element("rd");
            JDomUtils.addChild((Element)rd, (String)"iSeqno", (String)info.getBankSerialNo());
            JDomUtils.addChild((Element)rd, (String)"ReimburseNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ReimburseNum", (String)"");
            if (isProduct && null != info.getBookingTime() && info.getBookingTime().toLocalDate().isAfter(LocalDate.now())) {
                JDomUtils.addChild((Element)rd, (String)"StartDate", (String)info.getBookingTime().format(DateTimeFormatter.BASIC_ISO_DATE));
                PaymentUtil.setBookPayFlag((PaymentInfo)info);
            } else {
                JDomUtils.addChild((Element)rd, (String)"StartDate", (String)"");
            }
            JDomUtils.addChild((Element)rd, (String)"StartTime", (String)"");
            JDomUtils.addChild((Element)rd, (String)"PayType", (String)(info.getUrgent() != false ? "1" : "2"));
            JDomUtils.addChild((Element)rd, (String)"PayAccNo", (String)info.getAccNo());
            JDomUtils.addChild((Element)rd, (String)"PayAccNameCN", (String)info.getAccName());
            JDomUtils.addChild((Element)rd, (String)"PayAccNameEN", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecAccNo", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)rd, (String)"RecAccNameCN", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)rd, (String)"RecAccNameEN", (String)"");
            if (!info.getSameBank().booleanValue()) {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"2");
            } else if (CommonUtils.isInner2Outer(info.getIncomeAccNo())) {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"2");
            } else {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"1");
            }
            JDomUtils.addChild((Element)rd, (String)"IsSameCity", (String)"");
            JDomUtils.addChild((Element)rd, (String)"Prop", (String)(info.getIndividual() != false ? "1" : "0"));
            JDomUtils.addChild((Element)rd, (String)"RecICBCCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecCityName", (String)CommonUtils.substringChinese(StrUtil.trim((CharSequence)info.getIncomeBankAddress()), 40));
            JDomUtils.addChild((Element)rd, (String)"RecBankNo", (String)info.getIncomeCnaps());
            JDomUtils.addChild((Element)rd, (String)"RecBankName", (String)info.getIncomeBankName());
            JDomUtils.addChild((Element)rd, (String)"CurrType", (String)info.getCurrency());
            JDomUtils.addChild((Element)rd, (String)"PayAmt", (String)PackerUtils.convertYuan2CentStr((BigDecimal)info.getAmount()));
            JDomUtils.addChild((Element)rd, (String)"UseCode", (String)"");
            String exp = info.getExplanation();
            if (exp != null && exp.length() > 10) {
                exp = exp.substring(0, 10);
            }
            JDomUtils.addChild((Element)rd, (String)"UseCN", (String)exp);
            JDomUtils.addChild((Element)rd, (String)"EnSummary", (String)"");
            if (CommonUtils.purposeOrSummary("3")) {
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)"");
            } else if (BankBusinessConfig.isPostScriptIntercept()) {
                String PostScript = "";
                PostScript = !((PaymentInfo)paymentInfos.get(i)).is2SameBank() ? CommonUtils.substringChinese(StringUtils.trim((String)((PaymentInfo)paymentInfos.get(i)).getExplanation()), 60) : CommonUtils.substringChinese(StringUtils.trim((String)((PaymentInfo)paymentInfos.get(i)).getExplanation()), 100);
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)PostScript);
            } else {
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
            }
            String Summary = info.getExplanation();
            Summary = CommonUtils.substringChinese(StrUtil.trim((CharSequence)Summary), 20);
            JDomUtils.addChild((Element)rd, (String)"Summary", (String)(CommonUtils.purposeOrSummary("2") ? "" : Summary));
            if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
                JDomUtils.addChild((Element)rd, (String)"Ref", (String)ICBC_CMP_PayParser.getRef(((PaymentInfo)paymentInfos.get(i)).getBankBatchSeqId()));
            } else {
                JDomUtils.addChild((Element)rd, (String)"Ref", (String)ICBC_CMP_PayParser.getRef(((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId()));
            }
            if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue()) {
                PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            } else {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            }
            JDomUtils.addChild((Element)rd, (String)"Oref", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ERPSqn", (String)info.getBankDetailSeqID());
            JDomUtils.addChild((Element)rd, (String)"BusCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ERPcheckno", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhType", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhName", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"BankType", (String)"102");
            JDomUtils.addChild((Element)rd, (String)"FileNames", (String)"");
            JDomUtils.addChild((Element)rd, (String)"Indexs", (String)"");
            JDomUtils.addChild((Element)rd, (String)"PaySubNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecSubNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"MCardNo", (String)info.getProxyAccNo());
            JDomUtils.addChild((Element)rd, (String)"MCardName", (String)info.getProxyAccName());
            rdStr.append(JDomUtils.element2StringPlain((Element)rd, (String)encoding));
        }
        try {
            String message = rdStr.toString();
            logger.info("\u538b\u7f29\u524d\u7684\u4ed8\u6b3e\u62a5\u6587\u4e3a\uff1a" + message);
            String zipStr = ZipUtils.zipandBase64(message.getBytes(encoding));
            JDomUtils.addChild((Element)in, (String)"zip", (String)zipStr);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6 : %s\u3002", (String)"CompanyNewPayImpl_3", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), encoding), (Throwable)e);
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u538b\u7f29\u51fa\u73b0\u5f02\u5e38", (String)"CompanyNewPayImpl_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        in.getChild("TotalAmt").setText(PackerUtils.convertYuan2CentStr((BigDecimal)totalAmt));
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg, request.getPaymentInfos());
        return ICBC_CMP_Packer.createMessageWithHeadForPay(msgSigned, transCode, "0.0.1.0", 1, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        ICBC_CMP_PayParser.parsePayNew(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

