/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.services.balance;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zyb.dc.utils.GLBPacker;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        Element bank_root = new Element("Message");
        JDomUtils.addChild((Element)bank_root, (Element)GLBPacker.getHeadPackerData("05B2EActHistoryBalQry"));
        Element body = JDomUtils.addChild((Element)bank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)bankBalanceRequest.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)bankBalanceRequest.getEndDate()));
        String rqstStr = JDomUtils.root2String((Element)bank_root, (String)RequestContextUtils.getCharset());
        return rqstStr;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        ArrayList<BalanceInfo> result = new ArrayList<BalanceInfo>(1);
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ebenk.getChild("Sys_Head");
        String returnCode = head.getChildTextTrim("ReturnCode");
        String returnMsg = head.getChildTextTrim("ReturnMsg");
        if (!"000000".equals(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)returnCode, (String)returnMsg));
        }
        Element body = ebenk.getChild("Body");
        List list = body.getChildren("List");
        for (Element info : list) {
            BalanceInfo message = new BalanceInfo();
            String baseAcctNo = info.getChildTextTrim("BaseAcctNo");
            this.setBankAcnt(message, bankBalanceRequest.getBankAcntList(), baseAcctNo);
            message.setBankCurrency(bankBalanceRequest.getBankCurrency());
            String balance = info.getChildTextTrim("Balance");
            this.setCurrentBalance(message, balance);
            result.add(message);
        }
        return new EBBankBalanceResponse(result);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "05B2EActHistoryBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HistoryBalance_1", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/b2e/05B2EActHistoryBalQry.do?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("Password")).append("&SIGDATA=0");
        factory.setUri(sb.toString());
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
    }
}

