/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.services.payment.samebank;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zyb.dc.services.payment.samebank.SameBankPacker;
import kd.ebg.aqap.banks.zyb.dc.services.payment.samebank.SameBankParser;
import kd.ebg.aqap.banks.zyb.dc.services.payment.samebank.SameBankPayQueryImpl;
import kd.ebg.aqap.banks.zyb.dc.utils.Utils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class SameBankPayImpl
extends AbstractPayImpl
implements IPay {
    SameBankPacker sameBankPacker = new SameBankPacker();
    SameBankParser sameBankParser = new SameBankParser();

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SameBankPayQueryImpl.class;
    }

    public String getDeveloper() {
        return "jiewen_liang";
    }

    public String getBizCode() {
        return "01B2EBankInnerTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"SameBankPayImpl_0", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equals(paymentInfo.getSubBizType()) && paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        return this.sameBankPacker.packPay(Utils.listToArray(request.getPaymentInfos()));
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return this.sameBankParser.parsePay(Utils.listToArray(request.getPaymentInfos()), responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/b2e/01B2EBankInnerTransfer.do?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("Password")).append("&SIGDATA=1");
        factory.setUri(sb.toString());
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
    }
}

