/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.wzb.opa.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.wzb.opa.util.GetStore;
import kd.ebg.aqap.banks.wzb.opa.util.MsgParser;
import kd.ebg.aqap.banks.wzb.opa.util.PackerUtil;
import kd.ebg.aqap.banks.wzb.opa.util.PostUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final Logger logger = LoggerFactory.getLogger(DetailImpl.class);

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.doBiz(request);
    }

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        JSONObject body = PackerUtil.getBodyPage(this.getCurrentPage() + "");
        body.put("payAcctNo", (Object)acnt.getAccNo());
        body.put("startDate", (Object)(request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "000000"));
        body.put("endDate", (Object)(request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "235959"));
        return JSONObject.toJSONString((Object)body);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        String result = MsgParser.getReceMsg(responseStr);
        JSONObject response = JSONObject.parseObject((String)result);
        JSONObject data = response.getJSONObject("data");
        JSONArray array = data.getJSONArray("transList");
        String totalNum = response.getString("totalNum");
        if (StringUtils.isEmpty((String)totalNum)) {
            this.setLastPage(true);
        } else {
            String nowPage = this.getCurrentPage();
            if (Integer.parseInt(nowPage) * 100 >= Integer.parseInt(totalNum)) {
                this.setLastPage(true);
            } else {
                this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
            }
        }
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        if (array == null || array.size() == 0) {
            return new EBBankDetailResponse(detailList);
        }
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obiect = array.getJSONObject(i);
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(request.getBankCurrency());
            detail.setOppAccNo(obiect.getString("rcvAcctNo"));
            detail.setOppAccName(obiect.getString("rcvAcctName"));
            detail.setOppBankName(obiect.getString("rcvSysName"));
            detail.setAccName(request.getAcnt().getAccName());
            detail.setAccNo(request.getAcnt().getAccNo());
            String transferDate = obiect.getString("transDate");
            String transferTime = obiect.getString("transTime");
            detail.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setTransTime(LocalDateTime.parse(transferDate + " " + transferTime, DateTimeFormatter.ofPattern("yyyyMMdd HHmmss")));
            BigDecimal amount = new BigDecimal(obiect.getString("transAmt").replaceAll(",", ""));
            String dcFlag = obiect.getString("dcFlag");
            if (dcFlag.equalsIgnoreCase("1")) {
                detail.setDebitAmount(amount);
                detail.setCreditAmount(new BigDecimal(0));
            } else if (dcFlag.equalsIgnoreCase("2")) {
                detail.setDebitAmount(new BigDecimal(0));
                detail.setCreditAmount(amount);
            }
            String absInfo = obiect.getString("absInfo");
            if (absInfo != null && absInfo.indexOf("_KD_") != -1) {
                String KDRetFlag = BizNoUtil.getId((String)absInfo);
                if (KDRetFlag.length() > 8) {
                    KDRetFlag = KDRetFlag.substring(KDRetFlag.length() - 8);
                }
                detail.setPayBankDetailSeqID(KDRetFlag);
                String exp = BizNoUtil.getMsg((String)absInfo);
                detail.setExplanation(exp);
            } else {
                detail.setExplanation(absInfo);
            }
            detail.setBankDetailNo(obiect.getString("transSeqno"));
            if (StringUtils.isNotEmpty((String)obiect.getString("payAcctBal"))) {
                detail.setBalance(new BigDecimal(obiect.getString("payAcctBal").replaceAll(",", "")));
            }
            detail.setJsonMap(JSONObject.toJSONString((Object)obiect));
            detailList.add(detail);
        }
        detailResponse.setDetails(detailList);
        return detailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "queryhourdetails";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-aqap-banks-wzb-opa", (Object[])new Object[0]);
    }

    public EBBankDetailResponse doBiz(BankDetailRequest rqst) {
        String url = GetStore.getBaseUrl() + "/V1/P01512/S01/queryhourdetails";
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = PostUtil.sendMsg(rqstStr, url);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage(1);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            detailInfos.addAll(detailResponse.getDetails());
        }
        return new EBBankDetailResponse(detailInfos);
    }
}

