/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.anz.dc.service.payment.oversea.querypay;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.anz.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.anz.dc.service.ANZ_DC_Packer;
import kd.ebg.aqap.banks.anz.dc.service.ANZ_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public int getBatchSize() {
        return BankBusinessConfig.getBatchNumber();
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element simulator = new Element("simulator");
        Element head = ANZ_DC_Packer.createHead("QUERY_BATCH_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)reqPara, (String)"batchSequence", (String)paymentInfos[0].getBankBatchSeqId());
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
            JDomUtils.addChild((Element)list, (String)"serialNo", (String)paymentInfos[i].getBankDetailSeqId());
        }
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = ANZ_DC_Parser.parseHeader(root);
        if ("BIZ_FAIL".equals(rsp.getResponseCode()) || !"BIZ_SUCCESS".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String serialNo = JDomUtils.getChildTextTrim((Element)list, (String)"serialNo");
            String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
            Element status = JDomUtils.getChildElement((Element)list, (String)"status");
            String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
            String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
            String actualAmount = JDomUtils.getChildTextTrim((Element)list, (String)"actualAmount");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)serialNo);
            if (null == info) {
                this.logger.error("\u672a\u5339\u914d\u5230\u6d41\u6c34\u53f7" + serialNo + "\u7684\u4ed8\u6b3e\u8bb0\u5f55");
                continue;
            }
            this.logger.info("\u5f53\u524d\u7684\u91d1\u989d\uff1a" + info.getAmount());
            if (!StringUtils.isEmpty((String)actualAmount)) {
                info.setAmount(new BigDecimal(actualAmount));
            }
            if ("BCC_PAY_SUCCESS".equals(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_ID_NOT_EXIST".equals(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_FAIL".equals(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_SUBMT_SUCCESS".equals(txStatus)) {
                if (BankBusinessConfig.isPayStateTimeout(info.getSubmitSuccessTime())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        for (PaymentInfo info : paymentInfos) {
            if (PaymentState.SUBMITED.getId() != info.getStatus().intValue() || !BankBusinessConfig.isPayStateTimeout(info.getSubmitSuccessTime())) continue;
            this.logger.info("\u4ed8\u6b3e\u72b6\u6001\u540c\u6b65\u8d85\u65f6\uff0c\u8bbe\u7f6e\u4ed8\u6b3e\u72b6\u6001\u672a\u4ea4\u6613\u672a\u786e\u8ba4");
            info.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
            info.setStatusMsg(ResManager.loadKDString((String)"\u4ed8\u6b3e\u72b6\u6001\u540c\u6b65\u8d85\u51fa\u9650\u5b9a\u65f6\u95f4\u3002", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

