/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.bank.meta.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.aqap.common.framework.bank.meta.template.BaseMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public abstract class PNMetaDataTemplate
extends BaseMetaDataTemplate {
    @Override
    public BankVersionMetaInfo getBankVersionMetaInfo() {
        this.metaDataInit();
        String dLockNum = this.bankShortName + "_concurrentCount";
        int concurrentCount = 0;
        try {
            if (!StringUtils.isEmpty((String)System.getProperty(dLockNum))) {
                concurrentCount = Integer.parseInt(System.getProperty(dLockNum));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BankVersionMetaInfo.builder().bankShortName(this.bankShortName).bankName(this.bankName).bankVersionID(this.bankVersionID).bankVersionName(this.bankVersionName).description(this.description).keyNames(this.keyNames).concurrentCount(concurrentCount).build();
    }

    @Override
    public List<BankVersionMetaInfo> getBankVersionExtMetaInfos() {
        this.metaDataInit();
        String fileName = this.bankVersionID + "_BankInfoExt.json";
        return this.initBankVersionMetaExtInfo(fileName);
    }

    @Override
    public List<BankLoginConfig> getBankLoginConfig() {
        this.baseConfigInit();
        ArrayList<BankLoginConfig> bankLoginConfig = new ArrayList<BankLoginConfig>(1);
        List<BankLoginConfig> configs = this.getBankFrontConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.PROXY_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getConcurrencyConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BASE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginBanksConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BANKS_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getPgpConfigSupplement();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.PGP_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginExtraConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.EXTRA_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        return bankLoginConfig;
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"ip", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1IP\u5730\u5740", "PNMetaDataTemplate_0", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4ee3\u7406\u7a0b\u5e8f\u670d\u52a1\u5668IP\uff0c\u8be5\u7248\u672c\u6ca1\u6709\u94f6\u884c\u524d\u7f6e\u673a\u8f6f\u4ef6\uff0c\u9700\u4f7f\u7528\u91d1\u8776\u524d\u7f6e\u4ee3\u7406\u8f6f\u4ef6\u4e0e\u94f6\u884c\u4ea4\u4e92\u3002", "PNMetaDataTemplate_1", "ebg-aqap-common"), (String)this.host, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangePort", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u7aef\u53e3\u53f7", "PNMetaDataTemplate_2", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4ee3\u7406\u7a0b\u5e8f\u7684\u670d\u52a1\u7aef\u53e3\u53f7", "PNMetaDataTemplate_3", "ebg-aqap-common"), (String)this.port, (boolean)false, (boolean)false).set2Integer().set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"frontProxy_Port", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6587\u4ef6\u4e1a\u52a1\u670d\u52a1\u7aef\u53e3\u53f7", "PNMetaDataTemplate_4", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4ee3\u7406\u7a0b\u5e8f\u7684\u6587\u4ef6\u4e1a\u52a1\u670d\u52a1\u7aef\u53e3\u53f7", "PNMetaDataTemplate_5", "ebg-aqap-common"), (String)"7777", (boolean)false, (boolean)false).set2IntegerPort(), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangeProtocol", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u901a\u8baf\u534f\u8bae", "PNMetaDataTemplate_6", "ebg-aqap-common"), (String)this.protocol, (boolean)true, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"timeout", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u8d85\u65f6\u8bbe\u7f6e\uff08\u5206\u949f\uff09", "PNMetaDataTemplate_7", "ebg-aqap-common"), (String)String.valueOf(this.timeout), (boolean)true, (boolean)false).set2Integer(), BankLoginConfigUtil.getMlBankLoginConfig((String)"charset", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5b57\u7b26\u96c6", "PNMetaDataTemplate_8", "ebg-aqap-common"), (String)this.charset, (boolean)true, (boolean)false)});
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getPgpConfigSupplement() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankService>> getBizImplClasses() {
        return null;
    }

    @Override
    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return null;
    }

    @Override
    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return null;
    }

    @Override
    public BankPropertyConfig getPropertyConfig() {
        return null;
    }

    @Override
    public boolean showInJdy() {
        return false;
    }
}

