/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.properties;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.PropertyChecker;
import kd.ebg.aqap.common.framework.properties.PropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.aqap.common.framework.properties.PropertyName;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class SystemPropertyConfig
implements PropertyConfig {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(SystemPropertyConfig.class);
    public static final String METHOD_MATCHING = "MATCHING";
    public static final String METHOD_FILTERING = "FILTERING";
    public static final PropertyConfigItem PAYMENT_ALLOW = PropertyConfigItem.builder().key("payment_allow").mlName(new MultiLangEnumBridge("\u652f\u4ed8\u901a\u9053\u5f00\u5173", "SystemPropertyConfig_0", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u914d\u7f6e\u4e3a'\u5f00'\u65f6\uff0c\u652f\u4ed8\u901a\u9053\u5f00\u653e\u3002\u914d\u7f6e\u4e3a'\u5173'\u65f6\uff0c\u652f\u4ed8\u901a\u9053\u5173\u95ed\u3002", "SystemPropertyConfig_1", "ebg-aqap-common")})).mlSourceNames(mlOnOffCN).sourceValues(onOffEN).defaultValues(defaultOn).minValueNum(1).maxValueNum(1).type(BusinessPropertyConfigType.PAY_PARAM.getName()).mustInput(true).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).build();
    public static final PropertyConfigItem NOT_PAYMENT_ALLOW = PropertyConfigItem.builder().key("not_payment_allow").mlName(new MultiLangEnumBridge("\u975e\u652f\u4ed8\u901a\u9053\u5f00\u5173", "SystemPropertyConfig_2", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u914d\u7f6e\u4e3a'\u5f00'\u65f6\uff0c\u5176\u4ed6\u901a\u9053\u5f00\u653e\u3002\u914d\u7f6e\u4e3a'\u5173'\u65f6\uff0c\u5176\u4ed6\u901a\u9053\u5173\u95ed\u3002", "SystemPropertyConfig_3", "ebg-aqap-common")})).mlSourceNames(mlOnOffCN).sourceValues(onOffEN).defaultValues(defaultOn).minValueNum(1).maxValueNum(1).mustInput(true).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).type(BusinessPropertyConfigType.PAY_PARAM.getName()).build();
    public static final PropertyConfigItem DATECENTER_CHECK = PropertyConfigItem.builder().key("datecenter_check").mlName(new MultiLangEnumBridge("\u6570\u636e\u4e2d\u5fc3\u6821\u9a8c", "SystemPropertyConfig_4", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u914d\u7f6e\u4e3a'\u5f00'\u65f6\uff0c\u6821\u9a8c\u8bf7\u6c42\u7684\u6570\u636e\u4e2d\u5fc3\u6765\u6e90\uff1b\u914d\u7f6e\u4e3a'\u5173'\u65f6\uff0c\u4e0d\u6821\u9a8c\u3002", "SystemPropertyConfig_5", "ebg-aqap-common")})).mlSourceNames(mlOnOffCN).sourceValues(onOffEN).defaultValues(defaultOff).minValueNum(1).maxValueNum(1).mustInput(true).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).type(BusinessPropertyConfigType.JOIN_UP_PARAM.getName()).build();
    public static final PropertyConfigItem ACCESS_MATCHING_METHOD = PropertyConfigItem.builder().key("access_matching_method").mlName(new MultiLangEnumBridge("\u8fc7\u6ee4IP\u7684\u89c4\u5219", "SystemPropertyConfig_6", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u8fc7\u6ee4IP\u7684\u89c4\u5219\uff0c\u767d\u540d\u5355\u8868\u793a\u4ec5\u5217\u8868\u4e2d\u7684IP\u53ef\u4ee5\u8bbf\u95ee\uff0c\u9ed1\u540d\u5355\u8868\u793a\u5217\u8868\u4e2d\u7684IP\u4e0d\u53ef\u4ee5\u8bbf\u95ee\u3002", "SystemPropertyConfig_7", "ebg-aqap-common")})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u767d\u540d\u5355", "SystemPropertyConfig_8", "ebg-aqap-common"), new MultiLangEnumBridge("\u9ed1\u540d\u5355", "SystemPropertyConfig_9", "ebg-aqap-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"MATCHING", "FILTERING"})).defaultValues(Lists.newArrayList((Object[])new String[]{"FILTERING"})).minValueNum(1).maxValueNum(1).mustInput(true).type(BusinessPropertyConfigType.JOIN_UP_PARAM.getName()).build();
    public static final PropertyConfigItem ACCESS_MATCHING_LIST = PropertyConfigItem.builder().key("access_matching_list").inputType(ConfigInputType.TEXTAREA.name()).mlName(new MultiLangEnumBridge("\u8fc7\u6ee4IP\u5217\u8868", "SystemPropertyConfig_10", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u8bbe\u7f6e\u8981\u8fc7\u6ee4\u4f7f\u7528\u7684IP\u5730\u5740\uff0c\u5982\u679c\u8981\u8f93\u5165\u591a\u4e2aIP\u8bf7\u7528;\u6216\u8005\u6362\u884c\u3002\u652f\u6301* \u5339\u914d\uff0c\u4f8b\u5982\uff1a192.168.*.1,\u5982\u679c\u8981\u5339\u914d\u533a\u95f4\uff0c\u53ef\u4ee5 172.17.5-6.31\u3002", "SystemPropertyConfig_11", "ebg-aqap-common")})).minValueNum(0).maxValueNum(255).type(BusinessPropertyConfigType.JOIN_UP_PARAM.getName()).build();
    public static final PropertyConfigItem DATACENTER_LIST = PropertyConfigItem.builder().key("datacenter_list").inputType(ConfigInputType.TEXTAREA.name()).mlName(new MultiLangEnumBridge("\u5141\u8bb8\u7684\u6570\u636e\u4e2d\u5fc3\u5217\u8868\uff08\u8d26\u5957id\uff09\u3002", "SystemPropertyConfig_12", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5728\u5217\u8868\u4e2d\u7684\u6570\u636e\u4e2d\u5fc3\u624d\u5141\u8bb8\u505a\u4e1a\u52a1\uff0c\u591a\u4e2a\u8bf7\u6362\u884c\u3002", "SystemPropertyConfig_13", "ebg-aqap-common")})).minValueNum(0).maxValueNum(255).type(BusinessPropertyConfigType.JOIN_UP_PARAM.getName()).build();
    public static final PropertyConfigItem QUERY_PAY_TIME_LIMIT = PropertyConfigItem.builder().key("QUERY_PAY_TIME_LIMIT").inputType(ConfigInputType.SELECT.name()).mlName(new MultiLangEnumBridge("\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u6700\u5c0f\u95f4\u9694\u65f6\u957f\u3002", "SystemPropertyConfig_14", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u6700\u5c0f\u95f4\u9694\u65f6\u957f\uff0c\u53ef\u9009\u503c\u8303\u56f4\u201810\u79d2\uff0c30\u79d2\uff0c1\u5206\u949f\uff0c3\u5206\u949f\u2019\uff0c\u9ed8\u8ba41\u5206\u949f\u3002", "SystemPropertyConfig_15", "ebg-aqap-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"10", "30", "60", "180"})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("10\u79d2", "SystemPropertyConfig_16", "ebg-aqap-common"), new MultiLangEnumBridge("30\u79d2", "SystemPropertyConfig_17", "ebg-aqap-common"), new MultiLangEnumBridge("1\u5206\u949f", "SystemPropertyConfig_18", "ebg-aqap-common"), new MultiLangEnumBridge("3\u5206\u949f", "SystemPropertyConfig_19", "ebg-aqap-common")})).defaultValues(Lists.newArrayList((Object[])new String[]{"60"})).type(BusinessPropertyConfigType.SYNC_PAY_PARAM.getName()).mustInput(true).build();
    public static final PropertyConfigItem QUERY_PAY_NEED_KD_FLAG_CHECK = PropertyConfigItem.builder().key("QUERY_PAY_NEED_KD_FLAG_CHECK").inputType(ConfigInputType.SELECT.name()).mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u5355\u662f\u5426\u4f9d\u9760\u4ea4\u6613\u6d41\u6c34\u8fdb\u884c\u4e8c\u6b21\u786e\u8ba4", "SystemPropertyConfig_40", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u53ea\u5f71\u54cd\u975e\u5e76\u7b14\u4ed8\u6b3e\uff0c\u5e76\u7b14\u4ed8\u6b3e\u4e0d\u53d7\u672c\u53c2\u6570\u63a7\u5236\u3002\u5728\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u65f6\uff0c\u68c0\u67e5\u6570\u636e\u5e93\u4e2d\u662f\u5426\u5b58\u5728\u76f8\u540c\u5bf9\u8d26\u7801\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u5982\u5b58\u5728\u5219\u66f4\u65b0\u4e3a\u4ea4\u6613\u6210\u529f\u5e76\u4e14\u9700\u8981\u6253\u4e0a\u4eba\u5de5\u4fee\u6539\u7684\u6807\u8bc6\uff0c\u5e76\u4e14\u9700\u8981\u628a\u66f4\u65b0\u7684\u539f\u56e0\u8f93\u51fa\u8fd4\u56de\u5230\u94f6\u4f01\u8fd4\u56de\uff1a\u5b58\u5728\u4ea4\u6613\u660e\u7ec6\uff08\u6d41\u6c34\u53f7xxx\uff09\uff0c\u94f6\u4f01\u81ea\u52a8/\u624b\u5de5\u66f4\u65b0\u4e3a\u4ea4\u6613\u6210\u529f\u3002", "SystemPropertyConfig_41", "ebg-aqap-common")})).sourceValues(falseTrueEN).mlSourceNames(mlFalseTrueCN).defaultValues(defaultFalse).type(BusinessPropertyConfigType.SYNC_PAY_PARAM.getName()).mustInput(true).build();
    public static final PropertyConfigItem OPEN_QUERY_PAY_LOG = PropertyConfigItem.builder().key("OPEN_QUERY_PAY_LOG").mlName(new MultiLangEnumBridge("\u662f\u5426\u8bb0\u5f55\u4ed8\u6b3e\u72b6\u6001\u67e5\u8be2\u65e5\u5fd7", "SystemPropertyConfig_23", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f\u5426\u8bb0\u5f55\u4ed8\u6b3e\u72b6\u6001\u67e5\u8be2\u65e5\u5fd7\uff0c\u9ed8\u8ba4\u8bb0\u5f55\u65e5\u5fd7\uff0c\u5f00\u542f\u8bb0\u5f55\u65e5\u5fd7\u65f6\uff0c\u53ef\u4ee5\u9a6c\u4e0a\u751f\u6548\u8bb0\u5f55\u65e5\u5fd7\u3002", "SystemPropertyConfig_24", "ebg-aqap-common")})).mlSourceNames(mlTrueFalseCN).sourceValues(onOffEN).defaultValues(defaultOn).minValueNum(1).maxValueNum(1).mustInput(true).type(BusinessPropertyConfigType.LOG_PARAM.getName()).build();
    public static final PropertyConfigItem OPEN_QUERY_PNOTE_DETAIL_LOG = PropertyConfigItem.builder().key("OPEN_QUERY_PNOTE_DETAIL_LOG").mlName(new MultiLangEnumBridge("\u662f\u5426\u8bb0\u5f55\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2\u65e5\u5fd7", "SystemPropertyConfig_50", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f\u5426\u8bb0\u5f55\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2\u65e5\u5fd7\uff0c\u9ed8\u8ba4\u8bb0\u5f55\u65e5\u5fd7\uff0c\u5f00\u542f\u8bb0\u5f55\u65e5\u5fd7\u65f6\uff0c\u53ef\u4ee5\u9a6c\u4e0a\u751f\u6548\u8bb0\u5f55\u65e5\u5fd7\u3002", "SystemPropertyConfig_51", "ebg-aqap-common")})).mlSourceNames(mlTrueFalseCN).sourceValues(onOffEN).defaultValues(defaultOn).minValueNum(1).maxValueNum(1).mustInput(true).type(BusinessPropertyConfigType.LOG_PARAM.getName()).build();
    public static final PropertyConfigItem OPEN_QUERY_PNOTE_DETAIL_HOLD_LOG = PropertyConfigItem.builder().key("OPEN_QUERY_PNOTE_DETAIL_HOLD_LOG").mlName(new MultiLangEnumBridge("\u662f\u5426\u8bb0\u5f55\u5728\u624b\u7968\u636e\u67e5\u8be2\u65e5\u5fd7", "SystemPropertyConfig_52", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f\u5426\u8bb0\u5f55\u5728\u624b\u7968\u636e\u67e5\u8be2\u65e5\u5fd7\uff0c\u9ed8\u8ba4\u8bb0\u5f55\u65e5\u5fd7\uff0c\u5f00\u542f\u8bb0\u5f55\u65e5\u5fd7\u65f6\uff0c\u53ef\u4ee5\u9a6c\u4e0a\u751f\u6548\u8bb0\u5f55\u65e5\u5fd7\u3002", "SystemPropertyConfig_53", "ebg-aqap-common")})).mlSourceNames(mlTrueFalseCN).sourceValues(onOffEN).defaultValues(defaultOn).minValueNum(1).maxValueNum(1).mustInput(true).type(BusinessPropertyConfigType.LOG_PARAM.getName()).build();
    public static final PropertyConfigItem OPEN_PROXY_AUTHOR = PropertyConfigItem.builder().key("OPEN_PROXY_AUTHOR").mlName(new MultiLangEnumBridge("\u4ee3\u7406\u7a0b\u5e8f\u662f\u5426\u5f00\u542f\u9274\u6743", "SystemPropertyConfig_25", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u7406\u7a0b\u5e8f\u662f\u5426\u5f00\u542f\u9274\u6743\uff0c\u9ed8\u8ba4\u4e0d\u9274\u6743\u3002\u5f00\u542f\u65f6\uff0c\u8bbf\u95ee\u4ee3\u7406\u7a0b\u5e8f\u9700\u8981\u767b\u5f55\u5e76\u4e14\u5bf9\u6570\u636e\u52a0\u5bc6\uff08\u90e8\u5206\u94f6\u884c\u652f\u6301\uff0c\u9700\u8981\u8054\u7cfb\u7814\u53d1\uff09\uff0c\u9700\u8981\u7ef4\u62a4\u7528\u6237\u540d\u3001\u5bc6\u7801\u3001\u79d8\u94a5\u3001\u5411\u91cf\u3002", "SystemPropertyConfig_26", "ebg-aqap-common")})).mlSourceNames(mlOnOffCN).sourceValues(onOffEN).defaultValues(defaultOff).minValueNum(1).maxValueNum(1).mustInput(true).type(BusinessPropertyConfigType.PROXY_PARAM.getName()).build();
    public static final PropertyConfigItem AES_KEY_SIZE = PropertyConfigItem.builder().key("AES_KEY_SIZE").mlName(new MultiLangEnumBridge("AES\u52a0\u5bc6\u7b97\u6cd5\u5bc6\u94a5\u957f\u5ea6", "SystemPropertyConfig_27", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u652f\u6301AES\u52a0\u5bc6\u7b97\u6cd5\u5bc6\u94a5\u957f\u5ea6\u4e3a128\u4f4d\u548c256\u4f4d\u3002", "SystemPropertyConfig_28", "ebg-aqap-common")})).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("128\u4f4d", "SystemPropertyConfig_29", "ebg-aqap-common"), new MultiLangEnumBridge("256\u4f4d", "SystemPropertyConfig_30", "ebg-aqap-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"128", "256"})).defaultValues(Lists.newArrayList((Object[])new String[]{"256"})).mustInput(true).type(BusinessPropertyConfigType.JOIN_UP_PARAM.getName()).build();
    public static final PropertyConfigItem CONNECT_WAIT_TIMEOUT = PropertyConfigItem.builder().key("CONNECT_WAIT_TIMEOUT").inputType(ConfigInputType.INTEGER.name()).mlName(new MultiLangEnumBridge("\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\u8303\u56f4", "SystemPropertyConfig_31", "ebg-aqap-common")).mlDesc(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\u8303\u56f4\uff0c\u8f93\u5165\u503c\uff1a2-60\uff0c\u5355\u4f4d\uff1as\uff08\u79d2\uff09\u3002", "SystemPropertyConfig_32", "ebg-aqap-common"), new MultiLangEnumBridge("\u4e1a\u52a1\u8bf7\u6c42\u524d\u4f1a\u5bf9\u94f6\u884c\u7aef\u53e3\u8fdb\u884c\u7f51\u7edc\u8fde\u63a5\uff0c\u9ed8\u8ba4\u4e3a2s\u65e0\u6cd5\u6b63\u5e38\u8fde\u63a5\uff0c\u5373\u793a\u4e3a\u8d85\u65f6\u3002\u5982\u7f51\u7edc\u4e0d\u7a33\u5b9a\u65f6\u53ef\u8c03\u6574\u8be5\u53c2\u6570\u9002\u914d\u7f51\u7edc\u8fde\u63a5\u65f6\u957f\u3002", "SystemPropertyConfig_33", "ebg-aqap-common"), new MultiLangEnumBridge("\u5982\u679c\u7f51\u7edc\u8fde\u63a560\u79d2\u8fd8\u4e0d\u80fd\u6b63\u5e38\u8fde\u63a5\uff0c\u9700\u8981\u6392\u67e5\u7f51\u7edc\u5f02\u5e38\u60c5\u51b5\u540e\u5728\u8fdb\u884c\u4e1a\u52a1\u63d0\u4ea4\u3002", "SystemPropertyConfig_34", "ebg-aqap-common")})).defaultValues(Lists.newArrayList((Object[])new String[]{"2"})).mustInput(true).minValueNum(2).maxValueNum(60).type(BusinessPropertyConfigType.JOIN_UP_PARAM.getName()).build();

    @Override
    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        return Lists.newArrayList((Object[])new PropertyConfigItem[]{PAYMENT_ALLOW, NOT_PAYMENT_ALLOW, ACCESS_MATCHING_METHOD, ACCESS_MATCHING_LIST, DATECENTER_CHECK, DATACENTER_LIST, QUERY_PAY_TIME_LIMIT, OPEN_QUERY_PAY_LOG, OPEN_PROXY_AUTHOR, AES_KEY_SIZE, QUERY_PAY_NEED_KD_FLAG_CHECK, CONNECT_WAIT_TIMEOUT});
    }

    @Override
    public String getPropertyConfigID() {
        return "common_business";
    }

    @Override
    public PropertyName getPropertyName() {
        return PropertyName.SYSTEM;
    }

    @Override
    public String getConfigName() {
        return ResManager.loadKDString((String)"\u7cfb\u7edf\u914d\u7f6e", (String)"SystemPropertyConfig_22", (String)"ebg-aqap-common", (Object[])new Object[0]);
    }

    @Override
    public String getConfigDesc() {
        return ResManager.loadKDString((String)"\u7cfb\u7edf\u914d\u7f6e", (String)"SystemPropertyConfig_22", (String)"ebg-aqap-common", (Object[])new Object[0]);
    }

    public static int getQueryPayTimeLimit() {
        int sec = 60;
        String value = QUERY_PAY_TIME_LIMIT.getCurrentValue();
        try {
            sec = Integer.parseInt(value);
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u914d\u7f6e'\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u6700\u5c0f\u95f4\u9694\u65f6\u957f'\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return sec;
    }

    public static boolean allowPay() {
        try {
            boolean currentValueAsBoolean = PAYMENT_ALLOW.getCurrentValueAsBoolean();
            return currentValueAsBoolean;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u914d\u7f6e'\u652f\u4ed8\u901a\u9053'\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return Boolean.TRUE;
        }
    }

    public static boolean allowOtherBiz() {
        try {
            boolean currentValueAsBoolean = NOT_PAYMENT_ALLOW.getCurrentValueAsBoolean();
            return currentValueAsBoolean;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u914d\u7f6e'\u975e\u652f\u4ed8\u901a\u9053'\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return Boolean.TRUE;
        }
    }

    public static boolean isMatchingMode() {
        try {
            boolean ignoreCase = METHOD_MATCHING.equalsIgnoreCase(ACCESS_MATCHING_METHOD.getCurrentValue());
            return ignoreCase;
        }
        catch (Exception e) {
            return Boolean.TRUE;
        }
    }

    public static List<String> getConfigIpList() {
        List<String> ipList = ACCESS_MATCHING_LIST.getCurrentValues();
        if (ipList != null) {
            ListIterator<String> infoIterator = ipList.listIterator();
            while (infoIterator.hasNext()) {
                String item = (String)infoIterator.next();
                if (!StringUtils.isEmpty((String)item)) continue;
                infoIterator.remove();
            }
        } else {
            ipList = new ArrayList<String>(1);
        }
        return ipList;
    }

    public static boolean isDatacenterCheckOpen() {
        try {
            boolean currentValueAsBoolean = DATECENTER_CHECK.getCurrentValueAsBoolean();
            return currentValueAsBoolean;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static List<String> getDatacenterList() {
        return DATACENTER_LIST.getCurrentValues();
    }

    public static List<String> getQueryDetailList() {
        ArrayList<String> detailAccNoItems = new ArrayList<String>(1);
        return detailAccNoItems;
    }

    public static boolean isScheduleLogOpen() {
        return false;
    }

    public static boolean isRuntimeLogOpen() {
        return false;
    }

    public static boolean isOpenQueryPayWithKdFlag() {
        return QUERY_PAY_NEED_KD_FLAG_CHECK.getCurrentValueAsBoolean();
    }

    public static int getConnectTimeout() {
        return CONNECT_WAIT_TIMEOUT.getCurrentValueAsInt();
    }
}

