/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.core.security.Signer;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.PaymentSigner;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfoArchive;
import kd.ebg.aqap.common.model.PaymentInfoRecord;
import kd.ebg.aqap.common.model.PaymentInfoUpdateRecord;
import kd.ebg.aqap.common.model.PaymentNoticeMsg;
import kd.ebg.aqap.common.model.repository.LinkPaymentInfoRepository;
import kd.ebg.aqap.common.model.repository.PaymentHashRepository;
import kd.ebg.aqap.common.model.repository.PaymentInfoArchiveRepository;
import kd.ebg.aqap.common.model.repository.PaymentInfoRecordRepository;
import kd.ebg.aqap.common.model.repository.PaymentInfoRepository;
import kd.ebg.aqap.common.model.repository.PaymentInfoUpdateRecordRepository;
import kd.ebg.aqap.common.model.repository.PaymentNoticeMsgRepository;
import kd.ebg.aqap.common.model.transform.PaymentTransFormer;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;

@Service
public class PaymentInfoService {
    EBGLogger log = EBGLogger.getInstance().getLogger(PaymentInfoService.class);
    private final PaymentInfoRepository paymentInfoRepository;
    private final PaymentInfoUpdateRecordRepository recordRepository;
    private final PaymentHashRepository paymentHashRepository;
    private final PaymentNoticeMsgRepository paymentExceptionRepository;
    private final boolean sign;
    private final String nodeId;
    @Autowired
    private PaymentInfoArchiveRepository paymentInfoArchiveRepository;
    @Autowired
    PaymentInfoRecordRepository paymentInfoRecordRepository;
    @Autowired
    private LinkPaymentInfoRepository linkPaymentInfoRepository;
    private Signer<PaymentInfo> signer;

    public PaymentInfoService(PaymentInfoRepository paymentInfoRepository, PaymentInfoUpdateRecordRepository recordRepository, PaymentHashRepository paymentHashRepository, PaymentNoticeMsgRepository paymentExceptionRepository, PaymentSigner paymentSigner, SingleNodeIDGetter nodeIDGetter) {
        this.paymentInfoRepository = paymentInfoRepository;
        this.recordRepository = recordRepository;
        this.paymentHashRepository = paymentHashRepository;
        this.paymentExceptionRepository = paymentExceptionRepository;
        this.sign = true;
        this.signer = paymentSigner;
        this.nodeId = nodeIDGetter.nodeID();
    }

    public static PaymentInfoService getInstance() {
        return SpringContextUtil.getBean(PaymentInfoService.class);
    }

    public boolean batchSeqIDExist(String batchSeqID) {
        return this.paymentInfoRepository.countByBatchSeqID(batchSeqID) > 0L;
    }

    public long countByAccNoAndCustomID(int start, int end, String accNo, String customId) {
        return this.paymentInfoRepository.countByStatusBetweenAndAccNoAndCustomID(start, end, accNo, customId);
    }

    public boolean isBatchOwnMe(String bankBatchSeqId) {
        this.log.info("\u672c\u6279\u6b21\u4ed8\u6b3e\u662f\u5426\u5c5e\u4e8e\u672c\u8282\u70b9\uff0c\u5f53\u524d\u8282\u70b9\u4e3a\uff1a" + this.nodeId);
        List<PaymentInfo> byBankBatchSeqID = this.paymentInfoRepository.findPackagedByBankBatchSeqID(bankBatchSeqId);
        if (byBankBatchSeqID != null && byBankBatchSeqID.size() > 0) {
            PaymentInfo info = byBankBatchSeqID.get(0);
            this.log.info("\u4ed8\u6b3e\u6279\u6b21\u53f7\u3010" + info.getBatchSeqID() + "\u3011\u7684\u4ed8\u6b3e\u8282\u70b9\u6807\u8bb0\u662f\uff1a" + info.getEbgID());
            if (!Objects.equals(info.getEbgID(), this.nodeId)) {
                return false;
            }
        }
        return true;
    }

    public void modifyOwnToMe(Map<String, List<PaymentInfo>> collect) {
        ArrayList<String> bankBatchSeqList = new ArrayList<String>(16);
        for (Map.Entry<String, List<PaymentInfo>> next : collect.entrySet()) {
            String bankBatchSeqId = next.getKey();
            bankBatchSeqList.add(bankBatchSeqId);
            List<PaymentInfo> paymentInfos = next.getValue();
            paymentInfos.forEach(info -> info.setEbgID(this.nodeId));
        }
        this.modifyDBOwnToMe(bankBatchSeqList);
    }

    private void modifyDBOwnToMe(List<String> bankBatchSeqList) {
        QFilter filter = new QFilter("bank_batch_seq_id", "in", bankBatchSeqList);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_bd_paymentinfo", (String)"ebg_id", (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("ebg_id", (Object)this.nodeId);
            }
            int total = dynamicObjects.length;
            int groupSize = 5000;
            int groupNum = total % groupSize == 0 ? total / groupSize : total / groupSize + 1;
            for (int i = 0; i < groupNum; ++i) {
                int start = i * groupSize;
                int end = (i + 1) * groupSize;
                if (end > total) {
                    end = total;
                }
                DynamicObject[] subDynamicObjects = Arrays.copyOfRange(dynamicObjects, start, end);
                SaveServiceHelper.save((DynamicObject[])subDynamicObjects);
            }
        }
    }

    public List<PaymentInfo> modifyOwnToMe(List<PaymentInfo> paymentInfos, String bankBatchSeqId) {
        this.log.info("\u4fee\u6539\u4ed8\u6b3e\u8282\u70b9\uff0c\u5f53\u524d\u8282\u70b9\u4e3a\uff1a" + this.nodeId);
        paymentInfos.forEach(info -> info.setEbgID(this.nodeId));
        QFilter filter = QFilter.of((String)"bank_batch_seq_id=?", (Object[])new Object[]{bankBatchSeqId});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_bd_paymentinfo", (String)"ebg_id", (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("ebg_id", (Object)this.nodeId);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        return paymentInfos;
    }

    public List<PaymentInfo> save(List<PaymentInfo> paymentInfos) {
        return this.save(paymentInfos, false);
    }

    public List<PaymentInfo> updateInManual(List<PaymentInfo> paymentInfos) {
        if (paymentInfos.size() == 0) {
            return paymentInfos;
        }
        paymentInfos.forEach(paymentInfo -> paymentInfo.setUpdateTime(LocalDateTime.now()));
        TXHandle h = TX.requiresNew();
        try {
            this.paymentInfoRepository.updateAll(paymentInfos, true);
            List<PaymentInfo> list = paymentInfos;
            return list;
        }
        catch (Exception e) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bb0\u5f55\u5199\u5165\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PaymentInfoService_0", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public List<PaymentInfo> save(List<PaymentInfo> paymentInfos, boolean insertAction) {
        if (paymentInfos.size() == 0) {
            return paymentInfos;
        }
        paymentInfos.forEach(paymentInfo -> {
            if (insertAction) {
                paymentInfo.setInsertTime(LocalDateTime.now());
            }
            paymentInfo.setUpdateTime(LocalDateTime.now());
        });
        TXHandle h = TX.requiresNew();
        try {
            if (insertAction) {
                if (this.sign && Objects.nonNull(this.signer)) {
                    this.paymentInfoRepository.insertAll(paymentInfos);
                    this.signer.signAndInsert(paymentInfos);
                }
            } else {
                paymentInfos = this.paymentInfoRepository.save(paymentInfos);
            }
            List<PaymentInfo> list = paymentInfos;
            return list;
        }
        catch (Exception e) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bb0\u5f55\u5199\u5165\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PaymentInfoService_0", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public List<PaymentInfo> selectByBatchSeqID(String batchSeqID) {
        return this.paymentInfoRepository.findByBatchSeqID(batchSeqID);
    }

    public List<PaymentInfo> selectByBankBatchSeqID(String bankBatchSeqID) {
        return this.paymentInfoRepository.findByBankBatchSeqID(bankBatchSeqID);
    }

    public List<PaymentInfo> compareAndStateState(List<PaymentInfo> paymentInfos, PaymentState expectedState, PaymentState state) {
        for (PaymentInfo info : paymentInfos) {
            if (info.getStatus().intValue() != expectedState.getId()) {
                this.log.info("\u4ed8\u6b3e :{} \u7684\u72b6\u6001:{} \u4e0e\u9884\u671f\u7684\u72b6\u6001: {}\u4e0d\u4e00\u81f4", new Object[]{info.getId(), info.getStatus(), expectedState.getId()});
                return null;
            }
            info.setStatus(state.getId());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
        }
        return paymentInfos;
    }

    public void recordStateChange(List<PaymentInfo> paymentInfos, boolean insertAction) {
        ArrayList<PaymentInfoUpdateRecord> records = new ArrayList<PaymentInfoUpdateRecord>(paymentInfos.size());
        String updateOperation = insertAction ? "insert" : "update";
        for (PaymentInfo info : paymentInfos) {
            PaymentInfoUpdateRecord updateRecord = new PaymentInfoUpdateRecord();
            updateRecord.setId(info.getId());
            updateRecord.setUpdateBatchSeq(Sequence.genSequence());
            FieldUtils.fieldsCopy((Object)info, (Object)updateRecord);
            updateRecord.setUpdateTime(LocalDateTime.now());
            updateRecord.setOperation(updateOperation);
            records.add(updateRecord);
        }
        this.recordRepository.save(records);
    }

    public List<PaymentInfo> selectByStatusAndOwnIsMe(int statusStart, int statusEnd, LocalDateTime date) {
        return this.paymentInfoRepository.findByStatusBetweenAndUpdateTimeLessThanAndEbgIDOrderByUpdateTimeAsc(statusStart, statusEnd, date, this.nodeId);
    }

    public List<PaymentInfo> selectByStatusAndOwnIsMe(LocalDateTime date, int limitNum) {
        return this.paymentInfoRepository.getNeedToQueryPaymentInfo(true, date, this.nodeId, limitNum);
    }

    public List<PaymentInfo> selectByStatusAndOwnIsNotMe(int statusStart, int statusEnd, LocalDateTime date) {
        return this.paymentInfoRepository.findByStatusBetweenAndUpdateTimeLessThanAndEbgIDNot(statusStart, statusEnd, date, this.nodeId);
    }

    public List<PaymentInfo> selectByStatusAndOwnIsNotMe(LocalDateTime date, int limitNum) {
        return this.paymentInfoRepository.getNeedToQueryPaymentInfo(false, date, this.nodeId, limitNum);
    }

    public List<PaymentInfo> selectByStatus(int status, LocalDateTime date, String ebgID) {
        return this.paymentInfoRepository.findByStatusAndUpdateTimeLessThanAndEbgID(status, date, ebgID);
    }

    public List<PaymentInfo> selectByBatchSeqIDAndDetailSeqID(String batchSeqID, String detailSeqID) {
        return this.paymentInfoRepository.findByBatchSeqIDAndDetailSeqID(batchSeqID, detailSeqID);
    }

    public List<PaymentInfo> selectByBatchSeqIDAndLinkpayDetailSeqId(String batchSeqID, String linkpaydetailSeqId) {
        return this.paymentInfoRepository.findByBatchSeqIDAndLinkpayDetailSeqId(batchSeqID, linkpaydetailSeqId);
    }

    public List<PaymentInfo> selectByStatus(int status) {
        return this.paymentInfoRepository.findByStatusAndEbgID(status, this.nodeId);
    }

    public List<PaymentInfo> findByStatusAndUpdateTimeLessThanAndInsertTimeAfterAndEbgIDNot(int status, LocalDateTime dateTime) {
        return this.paymentInfoRepository.findByStatusAndUpdateTimeLessThanAndInsertTimeAfterAndEbgIDNot(status, dateTime, LocalDateTime.now().minusHours(8L), this.nodeId);
    }

    public List<PaymentInfo> findByStatusAndInsertTimeBetweenAndEbgIDNot(int status, LocalDateTime dateTime, LocalDateTime limitTime) {
        return this.paymentInfoRepository.findByStatusAndInsertTimeBetweenAndEbgIDNot(status, dateTime, limitTime, this.nodeId);
    }

    public List<PaymentInfo> findByStatusAndUpdateTimeAfterAndEbgID(int status, LocalDateTime dateTime) {
        return this.paymentInfoRepository.findByStatusAndUpdateTimeAfterAndEbgID(status, dateTime, this.nodeId);
    }

    public boolean updateInvalidNodesFromSubmittingToUnknown(List<String> nonExistences) {
        String currentNode = SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID();
        for (String node : nonExistences) {
            List<PaymentInfo> submittingInfos = this.paymentInfoRepository.findByStatusAndEbgID(PaymentState.SUBMITTING.getId(), node);
            Optional.ofNullable(submittingInfos).ifPresent(paymentInfos -> {
                paymentInfos.forEach(info -> {
                    info.setBackStatus(info.getStatus());
                    info.setBackStatusMsg(info.getStatusMsg());
                    info.setStatus(PaymentState.UNKNOWN.getId());
                    info.setStatusName(PaymentState.UNKNOWN.getEnName());
                    info.setStatusMsg(PaymentState.UNKNOWN.getCnName());
                    info.setEbgID(currentNode);
                });
                this.paymentInfoRepository.save((List<PaymentInfo>)paymentInfos);
            });
            this.log.info("\u68c0\u67e5\u5386\u53f2\u8282\u70b9{}\u72b6\u6001\u4e3a\u201c\u63d0\u4ea4\u4e2dSUBMITTING\u201d\u7684\u4ed8\u6b3e\u6570\u636e\uff0c\u5c1d\u8bd5\u4fee\u6539\u4e3a\u5f53\u524d\u8282\u70b9{}\u201c\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\u201d\uff0c\u5df2\u627e\u5230{}\u6761", new Object[]{node, currentNode, submittingInfos.size()});
        }
        List<PaymentInfo> submittingInfos = this.paymentInfoRepository.findByStatusAndEbgID(PaymentState.SUBMITTING.getId(), currentNode);
        if (submittingInfos.size() > 0) {
            Optional.ofNullable(submittingInfos).ifPresent(paymentInfos -> {
                paymentInfos.forEach(info -> {
                    info.setBackStatus(info.getStatus());
                    info.setBackStatusMsg(info.getStatusMsg());
                    info.setStatus(PaymentState.UNKNOWN.getId());
                    info.setStatusName(PaymentState.UNKNOWN.getEnName());
                    info.setStatusMsg(PaymentState.UNKNOWN.getCnName());
                });
                String bankBatchSeqID = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID();
                if (!this.checkSubmitRepeat(bankBatchSeqID)) {
                    this.paymentInfoRepository.save((List<PaymentInfo>)paymentInfos);
                    this.log.info("\u68c0\u67e5\u5f53\u524d\u8282\u70b9{}\u72b6\u6001\u4e3a\u201c\u63d0\u4ea4\u4e2dSUBMITTING\u201d\u7684\u4ed8\u6b3e\u6570\u636e\uff0c\u5c1d\u8bd5\u4fee\u6539\u4e3a\u201c\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\u201d\uff0c\u5df2\u627e\u5230{}\u6761", new Object[]{currentNode, submittingInfos.size()});
                } else {
                    this.log.info("\u68c0\u67e5\u5230\u4ed8\u6b3e\u5904\u4e8e\u4efb\u52a1\u5904\u7406\u4e2d");
                }
            });
        }
        return true;
    }

    public boolean checkSubmitRepeat(String key) {
        String ebKey = "eb_pay_" + key;
        if (CosmicCache.contains((String)ebKey)) {
            String value = CosmicCache.get((String)ebKey);
            return !StringUtils.isEmpty((String)value);
        }
        return false;
    }

    public void archivePaymentInfo(LocalDateTime updateTime, int statusStart, int statusEnd) {
        List<PaymentInfo> paymentInfos = this.paymentInfoRepository.findByUpdateTimeBeforeAndStatusBetween(updateTime, statusStart, statusEnd);
        this.log.info("\u51c6\u5907\u5f52\u6863\u7684\u652f\u4ed8\u8bb0\u5f55\u6570\uff1a" + paymentInfos.size());
        ArrayList<PaymentInfoArchive> paymentInfoArchives = new ArrayList<PaymentInfoArchive>(1);
        for (PaymentInfo paymentInfo : paymentInfos) {
            PaymentInfoArchive paymentInfoArchive = new PaymentInfoArchive();
            FieldUtils.fieldsCopy((Object)paymentInfo, (Object)paymentInfoArchive);
            paymentInfoArchive.setArchiveTime(LocalDateTime.now());
            paymentInfoArchives.add(paymentInfoArchive);
        }
        if (paymentInfoArchives.size() > 0) {
            this.paymentInfoArchiveRepository.save(paymentInfoArchives);
            this.log.info("\u5df2\u5f52\u6863\u7684\u652f\u4ed8\u8bb0\u5f55\u6570\uff1a" + paymentInfoArchives.size());
            this.paymentInfoRepository.deleteByUpdateTimeBeforeAndStatusBetween(updateTime, statusStart, statusEnd);
        }
    }

    public PaymentInfo selectUpdateRecords(String id) {
        PaymentInfo paymentInfo = this.paymentInfoRepository.findOne(id);
        return paymentInfo;
    }

    public void recordException(List<PaymentNoticeMsg> paymentExceptions) {
        if (paymentExceptions.size() > 0) {
            this.paymentExceptionRepository.save(paymentExceptions);
        }
    }

    public void saveSubmitBankRecord(List<PaymentInfoRecord> records, boolean isUpdate) {
        if (records.size() > 0) {
            this.paymentInfoRecordRepository.save(records, isUpdate);
        }
    }

    public PaymentInfoRecord findById(String id) {
        return this.paymentInfoRecordRepository.findById(id);
    }

    public Map<String, PaymentInfoRecord> getExistPaymentRecord(List<PaymentInfo> paymentInfos) {
        ArrayList<String> paymentIDList = new ArrayList<String>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            paymentIDList.add(paymentInfo.getId());
        }
        return this.paymentInfoRecordRepository.findByIds(paymentIDList);
    }

    public void insertPaymentAndUpdateLinkPaymentInfos(List<PaymentInfo> paymentInfos, List<LinkPaymentInfo> linkPaymentInfos) {
        if (CollectionUtils.isEmpty(paymentInfos)) {
            this.log.info("\u6d3e\u751f\u4ed8\u6b3e\u8bb0\u5f55\u6570\u4e3a\u7a7a\u3002");
            return;
        }
        EBContext context = EBContext.getContext();
        for (LinkPaymentInfo linkPaymentInfo : linkPaymentInfos) {
            linkPaymentInfo.setUpdateTime(LocalDateTime.now());
            linkPaymentInfo.setVersion(linkPaymentInfo.getVersion() + 1);
            for (int i = 0; i < paymentInfos.size(); ++i) {
                PaymentInfo payInfo = paymentInfos.get(i);
                payInfo.setUpdateTime(LocalDateTime.now());
                payInfo.setRequestSeq(context.getRequestSeqID());
                payInfo.setUpdateOperation(ResManager.loadKDString((String)"\u65b0\u589e\u4ed8\u6b3e\u5355", (String)"PaymentInfoService_1", (String)"ebg-aqap-common", (Object[])new Object[0]));
                payInfo.setInsertTime(LocalDateTime.now());
                payInfo.setSyncCount(0);
                payInfo.setVersion(1);
                payInfo.setEbgID(SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID());
                payInfo.setRequestTime(LocalDateTime.now());
            }
        }
        try (TXHandle h = TX.required();){
            PaymentInfoService.getInstance().save(paymentInfos, true);
            this.linkPaymentInfoRepository.save(linkPaymentInfos);
        }
    }

    public List<PaymentInfo> updateWithVersion(List<PaymentInfo> paymentInfos) {
        return PaymentTransFormer.getInstance().updateWithVersion(paymentInfos);
    }
}

