/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BankUniqueSeqUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class DetailUniqueUtils {
    private static DetailUniqueUtils util;

    public static synchronized DetailUniqueUtils getInstance() {
        if (util == null) {
            util = new DetailUniqueUtils();
        }
        return util;
    }

    public void buildDetailUniqueSeq(Element element, String accNo, DetailInfo detailInfo) {
        this.buildDetailUniqueSeq(accNo, this.getDetailJsonWithStructuredData(element), detailInfo);
    }

    public void buildDetailUniqueSeq(String base, String content, String spliter, String accNo, DetailInfo detailInfo) {
        this.buildDetailUniqueSeq(accNo, this.getDetailJsonWithNonStructuredData(base, content, spliter), detailInfo);
    }

    public String getDetailJsonWithStructuredData(Element element) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        if (element != null) {
            List children = element.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element node = (Element)children.get(i);
                jsonMap.put(node.getName(), element.getChildTextTrim(node.getName()));
            }
        }
        return JsonUtil.toJson(jsonMap);
    }

    public String getDetailJsonWithNonStructuredData(String base, String content, String spliter) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)base) && StringUtils.isNotEmpty((String)content)) {
            String[] BaseAttr = base.split(spliter);
            String[] items = content.split(spliter);
            for (int i = 0; i < BaseAttr.length; ++i) {
                jsonMap.put(BaseAttr[i], items[i]);
            }
        }
        return JsonUtil.toJson(jsonMap);
    }

    public void buildDetailUniqueSeq(String accNo, String jsonStr, DetailInfo detailInfo) {
        String bankVersionId = EBContext.getContext().getBankVersionID();
        Object impl = BankBundleManager.getInstance().getBankMetaDataCollectorImpl(bankVersionId);
        Map<String, String> map = impl.getDetailUniqueRule();
        if (map == null || map.isEmpty()) {
            return;
        }
        StringBuilder uniqueSeq = new StringBuilder();
        Map jsonMap = (Map)JsonUtil.fromJson((String)jsonStr, Map.class);
        for (Map.Entry<String, String> entryKey : map.entrySet()) {
            if ("accNo".equals(entryKey.getKey())) {
                uniqueSeq.append(accNo);
            } else if (jsonMap.containsKey(entryKey.getKey())) {
                String value = jsonMap.get(entryKey.getKey()).toString();
                uniqueSeq.append(DetailUniqueUtils.getDataFormat(entryKey.getValue(), value));
            }
            uniqueSeq.append('|');
        }
        String unique = uniqueSeq.toString();
        unique = unique.substring(unique.length());
        detailInfo.setUniqueSeq(unique);
        String detailUniqueVersion = BankBundleManager.getInstance().getBankVersionInfo(bankVersionId).getDetailUniqueVersion();
        detailInfo.setUniqueVersion(detailUniqueVersion);
    }

    public void buildDetailUniqueSeq(List<DetailInfo> detailInfos) {
        if (!CollectionUtils.isEmpty(detailInfos)) {
            DetailInfo detailInfo1 = detailInfos.get(0);
            String bankVersionId = detailInfo1.getBankVersionID();
            Object impl = BankBundleManager.getInstance().getBankMetaDataCollectorImpl(bankVersionId);
            Map<String, String> map = impl.getDetailUniqueRule();
            if (map == null || map.isEmpty()) {
                return;
            }
            String detailUniqueVersion = BankBundleManager.getInstance().getBankVersionInfo(bankVersionId).getDetailUniqueVersion();
            for (DetailInfo detailInfo : detailInfos) {
                StringBuilder uniqueSeq = new StringBuilder();
                String jsonStr = detailInfo.getJsonMap();
                if (StringUtils.isEmpty((String)jsonStr)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u4e3b\u952e\u6784\u5efa\u5931\u8d25\uff0c\u5f53\u524d\u94f6\u884c\u63d2\u4ef6jsonMap\u503c\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DetailUniqueUtils_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
                }
                Map jsonMap = (Map)JsonUtil.fromJson((String)jsonStr, Map.class);
                for (Map.Entry<String, String> entryKey : map.entrySet()) {
                    if ("accNo".equals(entryKey.getKey())) {
                        uniqueSeq.append(detailInfo.getAccNo());
                    } else if (jsonMap.containsKey(entryKey.getKey())) {
                        String value = jsonMap.get(entryKey.getKey()).toString();
                        uniqueSeq.append(DetailUniqueUtils.getDataFormat(entryKey.getValue(), value));
                    }
                    uniqueSeq.append('|');
                }
                String unique = uniqueSeq.toString();
                unique = unique.substring(0, unique.length() - 1);
                detailInfo.setUniqueSeq(unique);
                detailInfo.setUniqueVersion(detailUniqueVersion);
            }
        }
    }

    public void buildDetailUniqueSeq(DetailInfo detailInfo) {
        String bankVersionId = detailInfo.getBankVersionID();
        Object impl = BankBundleManager.getInstance().getBankMetaDataCollectorImpl(bankVersionId);
        Map<String, String> map = impl.getDetailUniqueRule();
        if (map == null || map.isEmpty()) {
            return;
        }
        StringBuilder uniqueSeq = new StringBuilder();
        String jsonStr = detailInfo.getJsonMap();
        if (StringUtils.isEmpty((String)jsonStr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u4e3b\u952e\u6784\u5efa\u5931\u8d25\uff0c\u5f53\u524d\u94f6\u884c\u63d2\u4ef6jsonMap\u503c\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DetailUniqueUtils_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        Map jsonMap = (Map)JsonUtil.fromJson((String)jsonStr, Map.class);
        for (Map.Entry<String, String> entryKey : map.entrySet()) {
            if ("accNo".equals(entryKey.getKey())) {
                uniqueSeq.append(detailInfo.getAccNo());
            } else if (jsonMap.containsKey(entryKey.getKey())) {
                String value = jsonMap.get(entryKey.getKey()).toString();
                uniqueSeq.append(DetailUniqueUtils.getDataFormat(entryKey.getValue(), value));
            }
            uniqueSeq.append('|');
        }
        String unique = uniqueSeq.toString();
        unique = unique.substring(0, unique.length() - 1);
        detailInfo.setUniqueSeq(unique);
        String detailUniqueVersion = BankBundleManager.getInstance().getBankVersionInfo(bankVersionId).getDetailUniqueVersion();
        detailInfo.setUniqueVersion(detailUniqueVersion);
    }

    public static String getDataFormat(String type, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        if (DetailUniqueTypeEnum.STRING.getType().equals(type)) {
            return value;
        }
        if (DetailUniqueTypeEnum.TIMESTAMP.getType().equals(type)) {
            if (value.length() > 19) {
                value = value.substring(0, 19);
            }
            return value.replace("-", "").replace(".", "").replace(" ", "");
        }
        if (DetailUniqueTypeEnum.BIGDECIMAL.getType().equals(type)) {
            return BankUniqueSeqUtil.parseNumber(value);
        }
        return value;
    }

    public static void main(String[] args) {
        System.out.println(DetailUniqueUtils.getDataFormat(DetailUniqueTypeEnum.TIMESTAMP.getType(), "2022-04-22-09.22.55.274359"));
    }
}

