/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.utils;

import java.util.Objects;
import kd.ebg.aqap.common.framework.frame.MatchDetailInfo;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class MatchDetailUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(MatchDetailUtils.class);

    public static MatchDetailInfo createMatchDetail(DetailInfo dbDetail, DetailInfo bankDetail) {
        MatchDetailInfo matchDetailInfo = new MatchDetailInfo(dbDetail, bankDetail);
        boolean forceCondition = dbDetail.getDebitAmount().equals(bankDetail.getDebitAmount()) && dbDetail.getCreditAmount().equals(bankDetail.getCreditAmount()) && dbDetail.getTransDate().equals(bankDetail.getTransDate()) && dbDetail.getCurrency().equals(bankDetail.getCurrency()) && (StringUtils.isEmpty((String)dbDetail.getOppAccNo()) || dbDetail.getOppAccNo().equals(bankDetail.getOppAccNo()) && (StringUtils.isEmpty((String)dbDetail.getOppAccName()) || dbDetail.getOppAccName().equals(bankDetail.getOppAccName())));
        int score = 0;
        if (forceCondition) {
            if (dbDetail.getBankDetailNo() != null && dbDetail.getBankDetailNo().equals(bankDetail.getBankDetailNo())) {
                score += 32;
            }
            if (dbDetail.getExplanation().equals(bankDetail.getExplanation())) {
                score += 16;
            }
            if (Objects.nonNull(dbDetail.getBalance()) && Objects.nonNull(bankDetail.getBalance()) && dbDetail.getBalance().equals(bankDetail.getBalance())) {
                score += 8;
            }
            if (Objects.nonNull(dbDetail.getTransTime()) && Objects.nonNull(bankDetail.getTransTime()) && dbDetail.getTransTime().equals(bankDetail.getTransTime())) {
                score += 4;
            }
            if (dbDetail.getIsKeyRepeat().equals(bankDetail.getIsKeyRepeat())) {
                score += 2;
            }
            if (score == 0) {
                logger.info("0\u5206\uff0c\u5f3a\u5236\u8bbe\u7f6e1\u5206\uff0c\u8fd8\u662f\u66f4\u65b0");
                score = 1;
            }
        }
        matchDetailInfo.setScore(score);
        return matchDetailInfo;
    }
}

