/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.front.api.boot.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.front.api.boot.utils.StringUtils;
import kd.ebg.aqap.common.model.DataCenter;
import kd.ebg.egf.common.entity.service.EBBaseRequest;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class FrontCheckUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FrontCheckUtil.class);
    private static final long TIME_STAMP_1S = 1000L;

    public static boolean checkTimeLimited(EBBaseRequest request, long milliSecond) {
        return FrontCheckUtil.checkTimeLimited(request, milliSecond, 1000L);
    }

    public static boolean checkTimeLimited(EBBaseRequest request, long milliSecond, long timeTolerate) {
        long timeNow = System.currentTimeMillis();
        return timeNow - milliSecond <= request.getTimestamp() && request.getTimestamp() <= timeNow + timeTolerate;
    }

    public static void checkRequest(EBBaseRequest request, String customID) {
        if (request == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"request\u5bf9\u8c61\u4e3a\u7a7a\u503c\u3002", (String)"FrontCheckUtil_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        if (request.getTimestamp() == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u6c42\u65f6\u95f4\u6233\u4e3a\u7a7a\u503c\u3002", (String)"FrontCheckUtil_1", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        String customerID = request.getCustomerID();
        if (StringUtils.isBlank(customerID)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"customerID\u4e3a\u7a7a\u503c\u3002", (String)"FrontCheckUtil_2", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        if (!customerID.equalsIgnoreCase(customID)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u6c42customerID \u4e0d\u4e00\u81f4\u3002", (String)"FrontCheckUtil_3", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
    }

    public static void checkRequest(EBBaseRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"request\u5bf9\u8c61\u4e3a\u7a7a\u503c\u3002", (String)"FrontCheckUtil_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        if (request.getTimestamp() == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u6c42\u65f6\u95f4\u6233\u4e3a\u7a7a\u503c\u3002", (String)"FrontCheckUtil_1", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        String customerID = request.getCustomerID();
        if (StringUtils.isBlank(customerID)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"customerID\u4e3a\u7a7a\u503c\u3002", (String)"FrontCheckUtil_2", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
    }

    public static String[] checkDataBase(Optional<DataCenter> dataCenter) {
        String version;
        String[] versions = new String[2];
        versions[0] = version = Objects.nonNull(dataCenter.get()) ? dataCenter.get().getVersion() : "";
        File user = FileCommonUtils.getFileByPath((String)System.getProperty("user.dir"));
        String path = user.getParent() + File.separator + "ebgPatch.xml";
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException e) {
            logger.error(e.toString());
        }
        try {
            Document document = reader.read(new File(path));
            Element root = document.getRootElement();
            versions[1] = root.attributeValue("version").replace(".", "_");
        }
        catch (DocumentException e) {
            versions[1] = "";
        }
        return versions;
    }

    public static boolean checkIPAllow(String ip, String allowIPStrings, String blockIPStrings) {
        boolean allow = true;
        boolean block = false;
        if (!Objects.isNull(allowIPStrings)) {
            allow = FrontCheckUtil.match(ip, allowIPStrings);
        }
        if (!Objects.isNull(blockIPStrings)) {
            block = FrontCheckUtil.match(ip, blockIPStrings);
        }
        return allow && !block;
    }

    private static String[] getIP(String ipStrings) {
        Preconditions.checkArgument((boolean)Objects.nonNull(ipStrings), (Object)ResManager.loadKDString((String)"ipStrings \u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"FrontCheckUtil_4", (String)"ebg-aqap-common", (Object[])new Object[0]));
        if (ipStrings == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"ipStrings\u5bf9\u8c61\u4e3a\u7a7a\u503c\u3002", (String)"FrontCheckUtil_5", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        return ipStrings.split("\n");
    }

    public static boolean match(String ip, String ipStrings) {
        return FrontCheckUtil.match(ip, FrontCheckUtil.getIP(ipStrings));
    }

    public static boolean match(String ip, String[] ipLists) {
        boolean flag = false;
        for (String key : ipLists) {
            if (!ip.equalsIgnoreCase(key)) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

