/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository.userwordkey;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.entity.userwordkey.BankInterfaceEntity;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class BankInterfaceRepository {
    public static final String ENTITY = "aqap_bank_interface";
    private String SELECT_ALL_PROPERTIES = "id,modifytime,createtime,creator,modifier,enable,status,bank.number,interface,usename";

    public void save(BankInterfaceEntity entity) {
        DynamicObject dynamicObject = this.packInfo(null, entity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public BankInterfaceEntity selectByInterfaceNameAndBankVersion(String interfaceName, String bankVersionId) {
        QFilter filter = QFilter.of((String)"interface=? and bank.number=?", (Object[])new Object[]{interfaceName, bankVersionId});
        BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            BankInterfaceEntity bankInterfaceEntity = this.toEntityInfo(dynamicObject);
            return bankInterfaceEntity;
        }
        return null;
    }

    public void update(BankInterfaceEntity entity) {
        DynamicObject dynamicObject = this.findOneById(entity.getId());
        dynamicObject = this.packInfo(dynamicObject, entity);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void deleteAllByIds(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])ids.toArray());
    }

    public DynamicObject selectById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
    }

    public BankInterfaceEntity findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            BankInterfaceEntity entity = this.toEntityInfo(dynamicObject);
            return entity;
        }
        return null;
    }

    public boolean isUniqueByInterfaceName(String interfaceName, String bankVersion) {
        QFilter filter = QFilter.of((String)"interface=? and bank.number=?", (Object[])new Object[]{interfaceName, bankVersion});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject == null;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    private BankInterfaceEntity toEntityInfo(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        BankInterfaceEntity entity = new BankInterfaceEntity();
        entity.setId(dynamicObject.getLong("id"));
        entity.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        entity.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        String enable = dynamicObject.getString("enable");
        if (!StringUtils.isEmpty((String)enable)) {
            entity.setEnable(Integer.parseInt(enable));
        }
        String creatorid = dynamicObject.getString("creator");
        entity.setCreatorid(creatorid);
        String modifierid = dynamicObject.getString("modifier");
        entity.setCreatorid(modifierid);
        String status = dynamicObject.getString("status");
        entity.setStatus(status);
        entity.setBankVersionId(dynamicObject.getString("bank.number"));
        entity.setInterfaceName(dynamicObject.getString("interface"));
        entity.setUsename(dynamicObject.getString("usename"));
        return entity;
    }

    private DynamicObject packInfo(DynamicObject dynamicObject, BankInterfaceEntity entity) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("creator", (Object)entity.getCreatorid());
        } else {
            dynamicObject.set("id", (Object)entity.getId());
            dynamicObject.set("modifytime", (Object)new Date());
        }
        dynamicObject.set("modifier", (Object)entity.getModifierid());
        dynamicObject.set("interface", (Object)entity.getInterfaceName());
        dynamicObject.set("usename", (Object)entity.getUsename());
        BankVersionRepository bankVersionRepository = SpringContextUtil.getBean(BankVersionRepository.class);
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(entity.getBankVersionId());
        dynamicObject.set("bank", (Object)bankVersion);
        dynamicObject.set("enable", (Object)entity.getEnable());
        dynamicObject.set("status", (Object)entity.getStatus());
        return dynamicObject;
    }
}

