/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository.userwordkey;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.entity.userwordkey.UseWordKeyEntity;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class UseWordKeyRepository {
    public static final String ENTITY = "aqap_use_key_word";
    private String SELECT_ALL_PROPERTIES = "id,use_keyword,desc,modifytime,createtime,creator,modifier,type,enable,status";

    public void save(UseWordKeyEntity entity) {
        DynamicObject dynamicObject = this.packInfo(null, entity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void update(UseWordKeyEntity entity) {
        DynamicObject dynamicObject = this.findOneById(entity.getId());
        dynamicObject = this.packInfo(dynamicObject, entity);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void deleteAllByIds(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITY);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])ids.toArray());
    }

    public DynamicObject selectById(Long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        return BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
    }

    public boolean isUniqueByWord(String wordKey) {
        QFilter filter = QFilter.of((String)"use_keyword = ?", (Object[])new Object[]{wordKey});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObjects.isEmpty();
    }

    public DynamicObject getByUseWordKey(String useWordKey) {
        QFilter filter = QFilter.of((String)"use_keyword = ?", (Object[])new Object[]{useWordKey});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public boolean isUniqueByWord(String wordKey, long id) {
        QFilter filter = QFilter.of((String)"use_keyword = ?", (Object[])new Object[]{wordKey});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects.isEmpty()) {
            return true;
        }
        if (dynamicObjects.size() == 1) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            long pid = dynamicObject.getLong("id");
            return pid == id;
        }
        return false;
    }

    public UseWordKeyEntity findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            UseWordKeyEntity entity = this.toEntityInfo(dynamicObject);
            return entity;
        }
        return null;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    private UseWordKeyEntity toEntityInfo(DynamicObject dynamicObject) {
        String enable;
        if (dynamicObject == null) {
            return null;
        }
        UseWordKeyEntity entity = new UseWordKeyEntity();
        entity.setId(dynamicObject.getLong("id"));
        entity.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        entity.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        entity.setDesc(dynamicObject.getString("desc"));
        entity.setUseKeyword(dynamicObject.getString("use_keyword"));
        String type = dynamicObject.getString("type");
        if (!StringUtils.isEmpty((String)type)) {
            entity.setType(Integer.parseInt(type));
        }
        if (!StringUtils.isEmpty((String)(enable = dynamicObject.getString("enable")))) {
            entity.setEnable(Integer.parseInt(enable));
        }
        String creatorid = dynamicObject.getString("creator");
        entity.setCreatorid(creatorid);
        String modifierid = dynamicObject.getString("modifier");
        entity.setCreatorid(modifierid);
        String status = dynamicObject.getString("status");
        entity.setStatus(status);
        return entity;
    }

    private DynamicObject packInfo(DynamicObject dynamicObject, UseWordKeyEntity entity) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("creator", (Object)entity.getCreatorid());
            dynamicObject.set("modifytime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)entity.getId());
            dynamicObject.set("modifytime", (Object)new Date());
        }
        dynamicObject.set("modifier", (Object)entity.getModifierid());
        dynamicObject.set("use_keyword", (Object)entity.getUseKeyword());
        dynamicObject.set("desc", (Object)entity.getDesc());
        dynamicObject.set("type", (Object)entity.getType());
        dynamicObject.set("enable", (Object)entity.getEnable());
        dynamicObject.set("status", (Object)entity.getStatus());
        return dynamicObject;
    }
}

