/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.utils;

import cn.com.infosec.icbc.ReturnValue;
import com.icbc.api.crypt.RSA;
import com.icbc.api.internal.util.codec.Base64;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kd.ebg.egf.common.log.EBGLogger;

public class KeyUtil {
    private static final byte[] START_PUBLIC_KEY_BYTES = "##############start public key##############".getBytes();
    private static final byte[] END_PUBLIC_KEY_BYTES = "##############end public key##############".getBytes();
    private static final byte[] START_PRIVATE_KEY_BYTES = "##############start private key##############".getBytes();
    private static final byte[] END_PRIVATE_KEY_BYTES = "##############end private key##############".getBytes();
    private static final String GENERATR_ALG = "key generate algorithm: ";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(KeyUtil.class);

    public static byte[] loadPrivateKeyFromStream(InputStream in) throws Exception {
        return KeyUtil.loadKeyFromStream(in, RSA.KeyType.PRIVATE_KEY);
    }

    protected static byte[] loadKeyFromStream(InputStream in, RSA.KeyType keyType) throws Exception {
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader rb = new BufferedReader(isr);
        StringBuilder privateKey = new StringBuilder();
        String line = null;
        boolean firstLine = true;
        boolean containsDesc = false;
        boolean start = false;
        while ((line = rb.readLine()) != null) {
            if (firstLine) {
                if (line.startsWith(GENERATR_ALG)) {
                    containsDesc = true;
                }
                firstLine = false;
            }
            if (containsDesc && !start) {
                if (keyType.equals((Object)RSA.KeyType.PRIVATE_KEY) && line.equals(new String(START_PRIVATE_KEY_BYTES))) {
                    start = true;
                    continue;
                }
                if (!keyType.equals((Object)RSA.KeyType.PUBLIC_KEY) || !line.equals(new String(START_PUBLIC_KEY_BYTES))) continue;
                start = true;
                continue;
            }
            if (start && (keyType.equals((Object)RSA.KeyType.PRIVATE_KEY) && line.equals(new String(END_PRIVATE_KEY_BYTES)) || keyType.equals((Object)RSA.KeyType.PUBLIC_KEY) && line.equals(new String(END_PUBLIC_KEY_BYTES)))) break;
            privateKey.append(line);
        }
        return Base64.decodeBase64((String)privateKey.toString());
    }

    public static String readStrFromFile(FileInputStream in) {
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader rb = new BufferedReader(isr);
        StringBuilder privateKey = new StringBuilder();
        String line = null;
        try {
            while ((line = rb.readLine()) != null) {
                privateKey.append(line);
            }
            return privateKey.toString().trim();
        }
        catch (IOException e) {
            logger.info(e.getMessage(), (Object)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCertBytes(String certPath) {
        FileInputStream fs = null;
        try {
            byte[] arrby;
            fs = new FileInputStream(certPath);
            byte[] certBytes = new byte[fs.available()];
            fs.read(certBytes);
            byte[] byArray = arrby = certBytes;
            return byArray;
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                logger.info(e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    public static String base64EncodeCert(String merCertPath) {
        String merCert = null;
        try {
            byte[] certBytes = KeyUtil.getCertBytes(merCertPath);
            byte[] merCer = ReturnValue.base64enc((byte[])certBytes);
            merCert = new String(merCer);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
        }
        return merCert;
    }
}

