/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.utils.gdbopa;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import kd.ebg.aqap.common.utils.gdbopa.SM2KeyPair;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.math.ec.ECConstants;

public class SM2Util {
    private static final X9ECParameters sm2p256v1 = GMNamedCurves.getByName((String)"sm2p256v1");
    private static final byte[] defaultUserID = "1234567812345678".getBytes();

    public static byte[] encrypt(byte[] publicKey, byte[] data) throws InvalidCipherTextException, IOException {
        if (publicKey.length == 64) {
            byte[] tmp = new byte[65];
            System.arraycopy(publicKey, 0, tmp, 1, publicKey.length);
            tmp[0] = 4;
            publicKey = tmp;
        }
        ECDomainParameters parameters = new ECDomainParameters(sm2p256v1.getCurve(), sm2p256v1.getG(), sm2p256v1.getN());
        ECPublicKeyParameters pubKeyParameters = new ECPublicKeyParameters(sm2p256v1.getCurve().decodePoint(publicKey), parameters);
        SM2Engine engine = new SM2Engine();
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)pubKeyParameters, new SecureRandom());
        engine.init(true, (CipherParameters)pwr);
        byte[] cipher = engine.processBlock(data, 0, data.length);
        return SM2Util.encodeSM2CipherToDER(cipher);
    }

    public static byte[] encodeSM2CipherToDER(byte[] cipher) throws IOException {
        int startPos = 1;
        int curveLength = (sm2p256v1.getCurve().getFieldSize() + 7) / 8;
        int digestLength = 32;
        byte[] c1x = new byte[curveLength];
        System.arraycopy(cipher, startPos, c1x, 0, c1x.length);
        byte[] c1y = new byte[curveLength];
        System.arraycopy(cipher, startPos += c1x.length, c1y, 0, c1y.length);
        byte[] c2 = new byte[cipher.length - c1x.length - c1y.length - 1 - digestLength];
        System.arraycopy(cipher, startPos += c1y.length, c2, 0, c2.length);
        byte[] c3 = new byte[digestLength];
        System.arraycopy(cipher, startPos += c2.length, c3, 0, c3.length);
        ASN1Encodable[] arr = new ASN1Encodable[4];
        arr[0] = new ASN1Integer(new BigInteger(1, c1x));
        if (new BigInteger(1, c1x).toByteArray().length < 32) {
            System.out.println("");
        }
        arr[1] = new ASN1Integer(new BigInteger(1, c1y));
        arr[2] = new DEROctetString(c3);
        arr[3] = new DEROctetString(c2);
        DERSequence ds = new DERSequence(arr);
        return ds.getEncoded("DER");
    }

    public static SM2KeyPair generateKeyPair() {
        ECDomainParameters parameters = new ECDomainParameters(sm2p256v1.getCurve(), sm2p256v1.getG(), sm2p256v1.getN());
        ECKeyGenerationParameters kgp = new ECKeyGenerationParameters(parameters, new SecureRandom());
        ECKeyPairGenerator ecKeyPairGenerator = new ECKeyPairGenerator();
        ecKeyPairGenerator.init((KeyGenerationParameters)kgp);
        ECPrivateKeyParameters ecpriv = null;
        ECPublicKeyParameters ecpub = null;
        do {
            AsymmetricCipherKeyPair keypair = ecKeyPairGenerator.generateKeyPair();
            ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
            ecpub = (ECPublicKeyParameters)keypair.getPublic();
        } while (ecpriv == null || ecpriv.getD().equals(ECConstants.ZERO) || ecpriv.getD().compareTo(sm2p256v1.getN()) >= 0 || ecpriv.getD().signum() <= 0);
        byte[] privKey = SM2Util.formartBigNum(ecpriv.getD(), 32);
        byte[] pubxKey = SM2Util.formartBigNum(ecpub.getQ().getAffineXCoord().toBigInteger(), 32);
        byte[] pubyKey = SM2Util.formartBigNum(ecpub.getQ().getAffineYCoord().toBigInteger(), 32);
        byte[] pubKey = new byte[64];
        System.arraycopy(pubxKey, 0, pubKey, 0, pubxKey.length);
        System.arraycopy(pubyKey, 0, pubKey, pubxKey.length, pubyKey.length);
        return new SM2KeyPair(privKey, pubKey);
    }

    private static byte[] formartBigNum(BigInteger bg, int needLength) {
        byte[] tmp = new byte[needLength];
        byte[] bgByte = bg.toByteArray();
        if (bgByte == null) {
            return null;
        }
        if (bgByte.length > needLength) {
            System.arraycopy(bgByte, bgByte.length - needLength, tmp, 0, needLength);
        } else if (bgByte.length == needLength) {
            tmp = bgByte;
        } else {
            System.arraycopy(bgByte, 0, tmp, needLength - bgByte.length, bgByte.length);
        }
        return tmp;
    }

    public static byte[] sign(byte[] privateKey, byte[] sourceData) throws CryptoException {
        return SM2Util.sign(defaultUserID, privateKey, sourceData);
    }

    public static byte[] sign(byte[] userId, byte[] privateKey, byte[] sourceData) throws CryptoException {
        ECDomainParameters parameters = new ECDomainParameters(sm2p256v1.getCurve(), sm2p256v1.getG(), sm2p256v1.getN());
        ECPrivateKeyParameters priKeyParameters = new ECPrivateKeyParameters(new BigInteger(1, privateKey), parameters);
        SM2Signer signer = new SM2Signer();
        Object param = null;
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)priKeyParameters, new SecureRandom());
        param = userId != null ? new ParametersWithID((CipherParameters)pwr, userId) : pwr;
        signer.init(true, (CipherParameters)param);
        signer.update(sourceData, 0, sourceData.length);
        return signer.generateSignature();
    }
}

