/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.detail;

import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CashPoolDetailPacker {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CashPoolDetailPacker.class);
    private final String trade_code = "200103";

    public String packCashPoolDetail(BankDetailRequest rqst) {
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData("200103", "0"));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getDetailRequestBody(rqst));
        String encoding = RequestContextUtils.getCharset();
        String rqstStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)encoding);
        return TCommon.createCommonMsg(rqstStr);
    }

    private Element getDetailRequestBody(BankDetailRequest request) {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"start_date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        logger.info(request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        logger.info(request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return body;
    }
}

