/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.services.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(AllocationPaymentImpl.class);
    private final String serviceId2 = "300216";

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return this.packPay(bankPayRequest);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if ("0000".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"AllocationPaymentImpl_0", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"AllocationPaymentImpl_1", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String packPay(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u7b14\u4ed8\u6b3e\u3002", (String)"AllocationPaymentImpl_2", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        }
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData2("300216", paymentInfos, "0"));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfos[0].getAmount().toString());
        if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0b\u62e8", (String)"AllocationPaymentImpl_3", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]).equals(paymentInfos[0].getUseCn())) {
            JDomUtils.addChild((Element)body, (String)"transtype", (String)"1");
        } else if (ResManager.loadKDString((String)"\u8d44\u91d1\u4e0a\u5212", (String)"AllocationPaymentImpl_4", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]).equals(paymentInfos[0].getUseCn())) {
            JDomUtils.addChild((Element)body, (String)"transtype", (String)"0");
        }
        JDomUtils.addChild((Element)body, (String)"purpose", (String)"");
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfos[0].getExplanation());
        String requestXml = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return requestXml;
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "300216";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u5212\u62e8", (String)"AllocationPaymentImpl_5", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

