/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.payment.otherbank.batch;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.services.payment.otherbank.batch.OtherBankBatchQueryPayImpl;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.IOUtils;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherBankBatchPaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OtherBankBatchPaymentImpl.class);
    private final String TRANCODE = "300006";

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return OtherBankBatchQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData2("300006", paymentInfos, "1"));
        String bankBatchSeqId = paymentInfos[0].getBankBatchSeqId();
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)bankBatchSeqId);
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfos[0].getAccName());
        StringBuilder content = new StringBuilder("cert_type|cert_no|rcv_acno|rcv_code|rcv_acname|rcv_accaddr|amt|as_flag|as_acno|as_acname|rcv_bankno|rcv_bankname|bank_flag|area_flag|urgency_flag|purpose|postscript|booking_flag|booking_date|booking_time|mobiles|saverecvinfo_flag|\r\n");
        BigDecimal totalamt = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            String is2SameBank = paymentInfos[i].is2SameBank() ? "0" : "1";
            String is2SameCity = paymentInfos[i].is2SameCity() ? "0" : "1";
            String is2Urgent = paymentInfos[i].is2Urgent() ? "1" : "0";
            content.append("|").append(paymentInfos[i].getBankDetailSeqId()).append("|").append(paymentInfos[i].getIncomeAccNo()).append("|").append(paymentInfos[i].getCurrency()).append("|").append(paymentInfos[i].getIncomeAccName()).append("|").append("|").append(paymentInfos[i].getAmount().toString()).append("|").append("|").append("|").append("|").append(paymentInfos[i].getIncomeCnaps()).append("|").append(paymentInfos[i].getIncomeBankName()).append("|").append(is2SameBank).append("|").append(is2SameCity).append("|").append(is2Urgent).append("|").append("|").append(paymentInfos[i].getExplanation()).append("|").append("|").append("|").append("|").append("|").append("|").append("\r\n");
            totalamt = totalamt.add(paymentInfos[i].getAmount());
        }
        JDomUtils.addChild((Element)body, (String)"amt", (String)String.valueOf(totalamt));
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)"");
        JDomUtils.addChild((Element)body, (String)"postscript", (String)ResManager.loadKDString((String)"\u6279\u91cf\u4ed8\u6b3e", (String)"OtherBankBatchPaymentImpl_0", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        Date now = new Date();
        String date = DateTimeUtils.format((Date)now, (String)"yyyyMMddHHmmss");
        String file_name = bankBatchSeqId + "@" + date;
        IOUtils.uploadFileFromLocal(file_name, content.toString());
        JDomUtils.addChild((Element)body, (String)"file_name", (String)file_name);
        String requestXml = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(requestXml);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if ("0000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8de8\u884c\u8f6c\u8d26", (String)"OtherBankBatchPaymentImpl_1", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

