/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.payment.otherbank.batch;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.IOUtils;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherBankBatchQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(OtherBankBatchQueryPayImpl.class);
    private static String serviceId1 = "200112";
    private static String serviceId2 = "200202";

    public int getBatchSize() {
        return 200;
    }

    public String pack(BankPayRequest bankPayRequest) {
        this.getSerialNo(bankPayRequest.getPaymentInfoAsArray());
        return this.pack200202(bankPayRequest.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseString) {
        this.parse200202(bankPayRequest, responseString);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    private void getSerialNo(PaymentInfo[] paymentInfos) {
        String reqString = this.pack200112(paymentInfos);
        String responseString = this.sendAndRcv4Query(reqString);
        this.parse200112(paymentInfos, responseString);
    }

    private String pack200112(PaymentInfo[] paymentInfos) {
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(serviceId1, "0"));
        Element body = new Element("body");
        String cms_corp_no = RequestContextUtils.getParameter().getBankParameter("cms_corp_no");
        String time = paymentInfos[0].getRequestTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"start_date", (String)time);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)time);
        if (cms_corp_no != null) {
            JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)cms_corp_no);
        } else {
            JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        }
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)encoding);
        String reqString = TCommon.createCommonMsg(requestMessage);
        return reqString;
    }

    private String pack200202(PaymentInfo[] paymentInfos) {
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(serviceId2, "0"));
        String cms_corp_no = RequestContextUtils.getParameter().getBankParameter("cms_corp_no");
        Element body = new Element("body");
        String bankBatchSeqId = paymentInfos[0].getBankBatchSeqId();
        String serial_no = PaymentInfoSysFiled.get((PaymentInfo)paymentInfos[0], (String)"serial_no");
        LocalDateTime requestTime = paymentInfos[0].getRequestTime();
        if (StringUtils.isEmpty((String)serial_no)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7serial_no\u4e3a\u7a7a\u3002", (String)"OtherBankBatchQueryPayImpl_9", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        }
        if (requestTime == null) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671ftr_acdt\u4e3a\u7a7a\u3002", (String)"OtherBankBatchQueryPayImpl_10", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
        }
        String time = requestTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)bankBatchSeqId);
        if (cms_corp_no != null) {
            JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)cms_corp_no);
        } else {
            JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        }
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)time);
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)encoding);
        return TCommon.createCommonMsg(requestMessage);
    }

    public void parse200202(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        Element body = bank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if (!"0000".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"OtherBankBatchQueryPayImpl_0", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            return;
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        String content = null;
        if (recordNum <= 0) {
            logger.error("###\u672c\u6b21\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002");
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"OtherBankBatchQueryPayImpl_1", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
            return;
        }
        if ("0".equals(head.getChildTextTrim("file_flag"))) {
            String serial_record;
            content = serial_record = body.getChildTextTrim("serial_record");
        } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
            String file_name = body.getChildTextTrim("file_name");
            content = IOUtils.downloadFileFromLocal(file_name);
        }
        String[][] rs = GLBParser.parseMFS(content, recordNum, fieldNum);
        OtherBankBatchQueryPayImpl.parsepayInfo(bankPayRequest, rs);
    }

    private static void parsepayInfo(BankPayRequest bankPayRequest, String[][] rs) {
        List<PaymentInfo> paymentInfos = OtherBankBatchQueryPayImpl.preBatchSameItemCheck(bankPayRequest);
        for (int i = 0; i < rs.length; ++i) {
            String accnbr = rs[i][13];
            String trsamt = rs[i][19];
            String TransStatus = rs[i][25];
            String errorInfo = rs[i][26];
            if (StringUtils.isEmpty((String)trsamt)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u90a2\u53f0\u94f6\u884c\u8fd4\u56de\u7684\u62a5\u6587\u683c\u5f0f\u9519\u8bef,\u91d1\u989dTRSAMT \u4e3a\u7a7a", (String)"OtherBankBatchQueryPayImpl_2", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
            }
            BigDecimal amount = new BigDecimal(trsamt.trim());
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)accnbr, (BigDecimal)(amount = amount.setScale(2)));
            if (null == paymentInfo) continue;
            OtherBankBatchQueryPayImpl.handlePayStatus(paymentInfo, TransStatus, errorInfo);
        }
        OtherBankBatchQueryPayImpl.processingBankItemDataHandler(rs);
        PayStatusMatchUtil.backBatchSameItemHandler((List)bankPayRequest.getPaymentInfos(), (boolean)false, (boolean)false);
    }

    private static List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    private static void processingBankItemDataHandler(String[][] rs) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (int i = 0; i < rs.length; ++i) {
                    String rcvAcNo = rs[i][13];
                    String rcvAcName = rs[i][15];
                    String amt = rs[i][19];
                    String bankDataKey = OtherBankBatchQueryPayImpl.getBankDataKey(rcvAcNo, rcvAcName, amt);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String TransStatus = rs[i][25];
                    String errorInfo = rs[i][26];
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    OtherBankBatchQueryPayImpl.handlePayStatus(tempInfo, TransStatus, errorInfo);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    private static PaymentInfo handlePayStatus(PaymentInfo tempInfo, String TransStatus, String errorInfo) {
        if ("9".equals(TransStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"OtherBankBatchQueryPayImpl_3", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)TransStatus, (String)"");
        } else if ("6".equals(TransStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"OtherBankBatchQueryPayImpl_4", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)TransStatus, (String)errorInfo);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"OtherBankBatchQueryPayImpl_0", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)TransStatus, (String)errorInfo);
        }
        return tempInfo;
    }

    private static String getBankDataKey(String incomeNo, String incomeName, String amount) {
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(incomeNo).append(incomeName).append(new BigDecimal(amount).setScale(2).toString());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getAmountErrorFormatTips(), (Throwable)e);
        }
        return buffer.toString();
    }

    /*
     * Exception decompiling
     */
    private String sendAndRcv4Query(String sendMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void parse200112(PaymentInfo[] paymentInfos, String rspStr) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        Element body = bank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if (!"0000".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"OtherBankBatchQueryPayImpl_0", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            return;
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        String content = null;
        if (recordNum <= 0) {
            logger.error("###\u672c\u6b21\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\u3002");
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"OtherBankBatchQueryPayImpl_4", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"OtherBankBatchQueryPayImpl_4", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]));
            return;
        }
        if ("0".equals(head.getChildTextTrim("file_flag"))) {
            String serial_record;
            content = serial_record = body.getChildTextTrim("serial_record");
        } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
            String file_name = body.getChildTextTrim("file_name");
            content = IOUtils.downloadFileFromLocal(file_name);
        }
        String[][] rs = GLBParser.parseMFS(content, recordNum, fieldNum);
        OtherBankBatchQueryPayImpl.parsepayInfo1(paymentInfos, rs);
    }

    private static void parsepayInfo1(PaymentInfo[] paymentInfos, String[][] rs) {
        for (int i = 0; i < rs.length; ++i) {
            String req_no = rs[i][1];
            if (!paymentInfos[0].getBankBatchSeqId().equals(req_no)) continue;
            String serial_no = rs[i][0];
            logger.info("\u83b7\u53d6\u7684\u94f6\u884c\u6d41\u6c34\u53f7\u4e3a\uff1a" + serial_no);
            String TransStatus = rs[i][13];
            if (!"0".equals(TransStatus)) continue;
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfos[0], (String)"serial_no", (String)serial_no);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return serviceId1 + "," + serviceId2;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8de8\u884c\u6279\u91cf\u4ed8\u6b3e\u7ed3\u679c", (String)"OtherBankBatchQueryPayImpl_8", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]);
    }
}

