/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.czccb.dc.service.payment.individual;

import kd.ebg.aqap.banks.czccb.dc.service.Packer;
import kd.ebg.aqap.banks.czccb.dc.service.Parser;
import kd.ebg.aqap.banks.czccb.dc.service.SignService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryPayPacker {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayPacker.class);

    public String packQueryPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        String header = Packer.createHeadMessage("CBE010106");
        String body = this.createBody(paymentInfos);
        String reqMsg = header + body;
        String signData = SignService.getSignData(reqMsg, "UTF-8");
        reqMsg = header + body + signData;
        String strLen = Packer.getLength(reqMsg);
        return strLen + reqMsg;
    }

    private String createBody(PaymentInfo[] paymentInfos) {
        StringBuilder sbBody = new StringBuilder();
        String encoding = "UTF-8";
        try {
            sbBody.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\"?>\r\n");
            sbBody.append("<BankData>");
            sbBody.append("<opReq>");
            sbBody.append("<ReqParam>");
            sbBody.append("<orderFlowNo>").append(paymentInfos[0].getBankRefID()).append("</orderFlowNo>");
            if (Parser.isSameBank(paymentInfos[0], logger)) {
                sbBody.append("<busiType>").append("BN").append("</busiType>");
            } else {
                sbBody.append("<busiType>").append("DP").append("</busiType>");
            }
            sbBody.append("</ReqParam>");
            sbBody.append("</opReq>");
            sbBody.append("</BankData>");
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        return sbBody.toString();
    }
}

