/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.srdc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.srdc.Packer;
import kd.ebg.aqap.banks.psbc.srdc.Parser;
import kd.ebg.aqap.banks.psbc.srdc.util.DomHelper;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final Logger log = LoggerFactory.getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("0");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse response = this.doBiz(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getDetails())) continue;
            detailInfos.addAll(response.getDetails());
        }
        return detailInfos;
    }

    public String pack(BankDetailRequest request) {
        Element root = Packer.createReqRootElement("1026");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Query_Account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Begin_Date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"End_Date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"PageNo", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)Param, (String)"PageNum", (String)"30");
        JDomUtils.addChild((Element)Param, (String)"Return_Flag", (String)"0");
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equals(protocol) || "HTTP".equals(protocol)) {
            return xmlStr;
        }
        return Packer.createCommonMsg(xmlStr);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.checkResponse(root, ResManager.loadKDString((String)"\u5b9a\u65e5\u671f\u4ea4\u6307\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
        if ("012717".equals(bankResponse.getResponseCode())) {
            this.setLastPage(true);
            detailResponse.setDetails(new ArrayList());
            this.setCurrentPage("");
            return detailResponse;
        }
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u8d26\u53f7(%1$s)\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u4ea4\u6613\u72b6\u6001[%2$s]\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u3002", (String)"DetailImpl_19", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]), request.getAcnt().getAccNo(), StringUtils.catWithSpace((String[])new String[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()})));
        }
        Element Param = DomHelper.getChildElementNotNull(root, "Param");
        String nextPage = Param.getChildText("NextPage");
        if (StringUtils.isEmpty((String)nextPage) || "-1".equals(nextPage)) {
            this.setLastPage(true);
        } else {
            this.setCurrentPage(nextPage);
        }
        List RecordSet = Param.getChildren("RecordSet");
        if (RecordSet.size() == 0) {
            detailResponse.setDetails(new ArrayList(16));
            this.setCurrentPage("");
            return detailResponse;
        }
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(16);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < RecordSet.size(); ++i) {
            DetailInfo detail;
            String Reserved1;
            String Remark;
            String Usage;
            String Trans_Date;
            String Bank_Serial;
            String Flag;
            String Balance;
            String Amount;
            Element record;
            block26: {
                String Cust_Acct;
                record = (Element)RecordSet.get(i);
                String tempCust_Acct = Cust_Acct = DomHelper.getChildTextNotNull(record, "Query_Account", ResManager.loadKDString((String)"\u4ea4\u6613\u8d26\u53f7", (String)"DetailImpl_5", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
                if (Cust_Acct.length() != request.getAcnt().getAccNo().length() && request.getAcnt().getAccNo().length() + 5 == Cust_Acct.length()) {
                    tempCust_Acct = Cust_Acct.substring(0, Cust_Acct.length() - 5);
                }
                if (!tempCust_Acct.equals(request.getAcnt().getAccNo())) {
                    EBServiceException exception = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7(%1$s)\u548c\u8bf7\u6c42\u8d26\u53f7(%2$s)\u4e0d\u7b26\u3002", (String)"DetailImpl_20", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]), Cust_Acct, request.getAcnt().getAccNo()));
                    log.info("", (Throwable)exception);
                    throw exception;
                }
                String Name = DomHelper.getChildTextNullAsBlank(record, "Name");
                String Account = DomHelper.getChildTextNotNull(record, "Account", ResManager.loadKDString((String)"\u5bf9\u65b9\u8d26\u53f7", (String)"DetailImpl_9", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
                String Bank = DomHelper.getChildTextNullAsBlank(record, "Bank");
                Amount = DomHelper.getChildTextNotNull(record, "Amount", ResManager.loadKDString((String)"\u53d1\u751f\u91d1\u989d", (String)"DetailImpl_10", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
                Balance = DomHelper.getChildTextNullAsBlank(record, "Balance");
                Flag = DomHelper.getChildTextNotNull(record, "Flag", ResManager.loadKDString((String)"\u8f6c\u51fa\u8f6c\u5165\u6807\u5fd7", (String)"DetailImpl_11", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
                Bank_Serial = DomHelper.getChildTextNotNull(record, "Bank_Serial", ResManager.loadKDString((String)"\u94f6\u884c\u6d41\u6c34\u53f7", (String)"DetailImpl_12", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
                Trans_Date = DomHelper.getChildTextNotNull(record, "Trans_Date", ResManager.loadKDString((String)"\u8f6c\u8d26\u65e5\u671f", (String)"DetailImpl_13", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
                String Trans_Time = DomHelper.getChildTextNotNull(record, "Trans_Time", ResManager.loadKDString((String)"\u8f6c\u8d26\u65f6\u95f4", (String)"DetailImpl_14", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
                Usage = DomHelper.getChildTextNullAsBlank(record, "Usage");
                Remark = DomHelper.getChildTextNullAsBlank(record, "Remark");
                Reserved1 = DomHelper.getChildTextNullAsBlank(record, "Reserved1");
                String Reserved2 = DomHelper.getChildTextNullAsBlank(record, "Reserved2");
                String EnterpriseID = DomHelper.getChildTextNullAsBlank(record, "EnterpriseID");
                detail = new DetailInfo();
                detail.setAccNo(request.getAcnt().getAccNo());
                detail.setAccName(request.getAcnt().getAccName());
                detail.setOppAccNo(Account);
                detail.setOppAccName(Name);
                detail.setOppBankName(Bank);
                detail.setCurrency(request.getBankCurrency());
                try {
                    if (!StringUtils.isEmpty((String)Trans_Date)) {
                        if (!StringUtils.isEmpty((String)Trans_Time)) {
                            detail.setTransDate(LocalDate.parse(Trans_Date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                            detail.setTransTime(LocalDateTime.parse(Trans_Date + Trans_Time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                        } else {
                            detail.setTransDate(LocalDate.parse(Trans_Date, DateTimeFormatter.ofPattern("yyyyMMdd")));
                            detail.setTransTime(LocalDateTime.parse(Trans_Date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                        }
                        break block26;
                    }
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u2018\u8f6c\u8d26\u65e5\u671f\u2019\u4e3a\u7a7a,\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u65e5\u671f.", (String)"DetailImpl_15", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:%s\u3002", (String)"DetailImpl_21", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
            }
            if ("1".equalsIgnoreCase(Flag)) {
                detail.setCreditAmount(BigDecimalHelper.div((String)Amount, (String)"100.00"));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else if ("0".equalsIgnoreCase(Flag)) {
                detail.setCreditAmount(new BigDecimal("0.00"));
                detail.setDebitAmount(BigDecimalHelper.div((String)Amount, (String)"100.00"));
            } else {
                EBServiceException ex = EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7:%s\u3002", (String)"DetailImpl_22", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]), Flag));
                log.info("", (Throwable)ex);
                throw ex;
            }
            if (!"".equals(Balance)) {
                detail.setBalance(BigDecimalHelper.div((String)Balance, (String)"100.00"));
            }
            detail.setExplanation(Usage);
            if (!StringUtils.isEmpty((String)Remark)) {
                int index = Remark.indexOf("_KD_");
                if (index != -1) {
                    String bankDetailSeqId = BizNoUtil.getId((String)Remark);
                    String remark = BizNoUtil.getMsg((String)Remark);
                    detail.setKdFlag(bankDetailSeqId);
                    detail.setPayBankDetailSeqID(bankDetailSeqId);
                    if (StringUtils.isEmpty((String)detail.getExplanation())) {
                        detail.setExplanation(remark);
                    }
                    DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                } else if (StringUtils.isEmpty((String)detail.getExplanation())) {
                    detail.setExplanation(Remark);
                }
            } else {
                detail.setExplanation(Reserved1);
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
            detail.setJsonMap(jsonStr);
            String accNo = request.getAcnt().getAccNo();
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, Trans_Date, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(Bank_Serial);
            totalList.add(detail);
        }
        detailResponse.setDetails(totalList);
        return detailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "1026";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6307\u5b9a\u65e5\u671f\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_18", (String)"ebg-aqap-banks-psbc-srdc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equals(protocol) || "HTTP".equals(protocol)) {
            String requesturl = RequestContextUtils.getBankParameterValue((String)"exchangeUri");
            factory.setUri(requesturl);
            factory.setHttpHeader("content-type", "application/xml;charset=GBK");
        } else {
            super.configFactory(factory);
            factory.setHttpHeader("Content-Type", "text/xml");
        }
    }
}

