/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.balance;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.citic.dc.services.ParserProxy;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchDepositBalBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DepositBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchDepositBalBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        List acntList = bankBalanceRequest.getBankAcntList();
        acntList = acntList.stream().filter(bankAcnt -> BankBusinessConfig.isQueryDepositBal(bankAcnt.getAccNo())).collect(Collectors.toList());
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"CMMACQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        for (BankAcnt acnt : acntList) {
            String accNo = acnt.getAccNo();
            Element row = JDomUtils.addChild((Element)list, (String)"row");
            JDomUtils.addChild((Element)row, (String)"accountNo", (String)accNo);
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Map<String, BankAcnt> bankAcntMap = this.getBankACNTMap(bankBalanceRequest);
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        Element list = root.getChild("list");
        List rows = list.getChildren("row");
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            BalanceInfo balanceInfo = new BalanceInfo();
            String currencyID = element.getChildTextTrim("currencyID");
            this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currencyID);
            balances.add(balanceInfo);
            String dePositBal = element.getChildTextTrim("GXAM");
            this.setDepositBalance(balanceInfo, dePositBal);
            String accountNo = element.getChildTextTrim("accountNo");
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), accountNo);
        }
        return new EBBankBalanceResponse(balances);
    }

    private Map<String, BankAcnt> getBankACNTMap(BankBalanceRequest bankBalanceRequest) {
        HashMap<String, BankAcnt> map = new HashMap<String, BankAcnt>(1);
        for (BankAcnt bankAcnt : bankBalanceRequest.getBankAcntList()) {
            map.put(bankAcnt.getAccNo(), bankAcnt);
        }
        return map;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMMACQRY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2\u63a5\u53e3", (String)"DepositBalanceImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        BankAcnt bankAcnt;
        LocalDate today = LocalDate.now();
        boolean matchTime = today.equals(request.getStartDate()) && today.equals(request.getEndDate());
        boolean matchConfig = false;
        List bankAcntList = request.getBankAcntList();
        Iterator iterator = bankAcntList.iterator();
        while (iterator.hasNext() && !(matchConfig = BankBusinessConfig.isQueryDepositBal((bankAcnt = (BankAcnt)iterator.next()).getAccNo()))) {
        }
        return matchTime && matchConfig;
    }
}

