/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.CashPoolHelper;
import kd.ebg.aqap.banks.citic.dc.services.FixedHelper;
import kd.ebg.aqap.banks.citic.dc.services.ParserProxy;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    public String pack(BankBalanceRequest request) {
        List acntList = request.getBankAcntList();
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLBALQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        for (BankAcnt acnt : acntList) {
            String accNo = acnt.getAccNo();
            Element row = JDomUtils.addChild((Element)list, (String)"row");
            JDomUtils.addChild((Element)row, (String)"accountNo", (String)accNo);
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element list = root.getChild("list");
        List rows = list.getChildren("row");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < rows.size(); ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            balances.add(balanceInfo);
            Element element = (Element)rows.get(i);
            String status = element.getChildTextTrim("status");
            String statusText = element.getChildTextTrim("statusText");
            if (!"AAAAAAA".equals(status)) {
                balanceInfo.setError(ShowTipUtil.getResponseErrorTips((String)status, (String)statusText));
            }
            this.setBankAcnt(balanceInfo, request.getBankAcntList(), element.getChildTextTrim("accountNo"));
            String currencyID = element.getChildTextTrim("currencyID");
            this.setBankCurrency(balanceInfo, request.getHeader().getBankCurrency(), currencyID);
            String currentBalance = element.getChildTextTrim("balance");
            String usableBalance = element.getChildTextTrim("usableBalance");
            String forzenAmt = element.getChildTextTrim("forzenAmt");
            this.setCurrentBalance(balanceInfo, currentBalance);
            this.setAvailableBalance(balanceInfo, usableBalance);
            this.setFreezeBalance(balanceInfo, forzenAmt);
            this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        }
        return new EBBankBalanceResponse(balances);
    }

    public boolean match(BankBalanceRequest request) {
        return !CashPoolHelper.isCashPoolAcnt(request.getHeader().getAcnt().getAccNo()) && !FixedHelper.isFixedAcnt(request.getHeader().getAcnt().getAccNo());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLBALQRY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public int limit() {
        return 10;
    }
}

