/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.credit.query;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.ParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.credit.query.QuryInfoImpl;
import kd.ebg.aqap.business.credit.queryCredit.atomic.AbstractCreditQueryImpl;
import kd.ebg.aqap.business.credit.queryCredit.atomic.ICreditDetail;
import kd.ebg.aqap.business.credit.queryCredit.bank.BankQueryCreditDetailRequest;
import kd.ebg.aqap.common.entity.biz.credit.Credit;
import kd.ebg.aqap.common.entity.biz.credit.QueryCreditRequest;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QuryCreditImpl
extends AbstractCreditQueryImpl
implements ICreditDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QuryCreditImpl.class);
    private static final int pageSize = 20;

    public String pack(BankQueryCreditDetailRequest request, Object o) {
        int page = request.getPageNum();
        String startNum = (page - 1) * 20 + 1 + "";
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLXMGAQY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"channelFlag", (String)"XMGM");
        JDomUtils.addChild((Element)root, (String)"ctfNum", (String)request.getApplicantCreditNum());
        JDomUtils.addChild((Element)root, (String)"startRecord", (String)startNum);
        JDomUtils.addChild((Element)root, (String)"pageNumber", (String)"20");
        JDomUtils.addChild((Element)root, (String)"startDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public List<Credit> parse(BankQueryCreditDetailRequest request, String responseStr) {
        ArrayList<Credit> credits = new ArrayList<Credit>();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            if ("PBRA001".equalsIgnoreCase(rsp.getResponseCode())) {
                return credits;
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4fe1\u7528\u8bc1\u5217\u8868\u8fd4\u56de\u975e\u6210\u529f\u4ea4\u6613\u7801\u3002\u94f6\u884c\u8fd4\u56de:%1$s,%2$s", (String)"QuryCreditImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element list = root.getChild("list");
        List rows = list.getChildren();
        for (int i = 0; i < rows.size(); ++i) {
            Credit credit;
            Element row = (Element)rows.get(i);
            String letOfcreNo = row.getChildTextTrim("letOfcreNo");
            String clientID = row.getChildTextTrim("clientID");
            if (!StringUtils.isNotEmpty((String)letOfcreNo) || (credit = this.getCreditDetail(letOfcreNo, request.getApplicantCreditNum())) == null) continue;
            credit.setDetailBizNo(clientID);
            credits.add(credit);
        }
        return credits;
    }

    private Credit getCreditDetail(String letOfcreNo, String ctfNum) {
        String encoding;
        String sendMsg = this.getDetailpacker(letOfcreNo, ctfNum);
        String responseStr = this.doBussiness(sendMsg);
        Element root = JDomUtils.string2Root((String)responseStr, (String)(encoding = RequestContextUtils.getCharset()));
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            log.error("\u67e5\u8be2\u4fe1\u7528\u8bc1\u5f02\u5e38\uff1a" + letOfcreNo);
            return null;
        }
        return new QuryInfoImpl().getEach(root);
    }

    private String getDetailpacker(String letOfcreNo, String ctfNum) {
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLXMGDET");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"channelFlag", (String)"XMGM");
        JDomUtils.addChild((Element)root, (String)"letOfcreNo", (String)letOfcreNo);
        JDomUtils.addChild((Element)root, (String)"ctfNum", (String)ctfNum);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "DLXMGAQY/DLXMGDET";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8fdb\u53e3\u4fe1\u7528\u8bc1\u5f00\u8bc1\u5217\u8868\u67e5\u8be2/\u8fdb\u53e3\u4fe1\u7528\u8bc1\u5f00\u8bc1\u8be6\u60c5\u67e5\u8be2", (String)"QuryCreditImpl_0", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(QueryCreditRequest queryCreditRequest) {
        return true;
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        return Integer.parseInt(pageTag) + 1 + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element list = root.getChild("list");
        List rows = list.getChildren();
        return rows == null || rows.size() < 20;
    }
}

