/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.dc.services.ParserProxy;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.item.TransTypeEnum;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    static final int PAGE_SIZE = 20;

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage("1");
        boolean isLastPage = false;
        this.setLastPage(isLastPage);
        while (!isLastPage) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            if (Objects.nonNull(detailResponse) && Objects.nonNull(detailResponse.getDetails())) {
                if (detailResponse.getDetails().size() == 0) break;
                detailInfos.addAll(detailResponse.getDetails());
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 20);
            isLastPage = this.isLastPage();
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage("1");
        boolean isLastPage = false;
        this.setLastPage(isLastPage);
        while (!isLastPage) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            if (Objects.nonNull(detailResponse) && Objects.nonNull(detailResponse.getDetails())) {
                if (detailResponse.getDetails().size() == 0) break;
                detailInfos.addAll(detailResponse.getDetails());
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 20);
            isLastPage = this.isLastPage();
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLTRNALL");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)accNo);
        JDomUtils.addChild((Element)root, (String)"lowAmount", (String)"0.00");
        JDomUtils.addChild((Element)root, (String)"upAmount", (String)"9999999999999.99");
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        JDomUtils.addChild((Element)root, (String)"startDate", (String)startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"endDate", (String)endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"pageNumber", (String)"20");
        JDomUtils.addChild((Element)root, (String)"startRecord", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)root, (String)"controlFlag", (String)"1");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            if ("PBRA001".equalsIgnoreCase(rsp.getResponseCode())) {
                return new EBBankDetailResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u975e\u6210\u529f\u4ea4\u6613\u7801\u3002\u94f6\u884c\u8fd4\u56de:%1$s,%2$s", (String)"DetailImpl_4", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        String accNo = ParserUtils.getUnNullElementTextValue((Element)root, (String)"accountNo", (String)ResManager.loadKDString((String)"\u8d26\u53f7", (String)"DetailImpl_1", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        int totalRecords = Integer.parseInt(root.getChildText("totalRecords"));
        int returnRecords = Integer.parseInt(root.getChildText("returnRecords"));
        int intPageTag = Integer.parseInt(this.getCurrentPage());
        if (intPageTag - 1 == totalRecords || returnRecords < 20) {
            this.setLastPage(true);
        }
        Element list = root.getChild("list");
        List rows = list.getChildren();
        for (int i = 0; i < rows.size(); ++i) {
            String receiptNo;
            DetailInfo detail = new DetailInfo();
            Element row = (Element)rows.get(i);
            String abstractText = row.getChildText("abstract");
            String balance = row.getChildText("balance");
            String cashTransferFlag = row.getChildText("cashTransferFlag");
            String ckId = row.getChildText("ckId");
            String ckName = row.getChildText("ckName");
            String creditDebitFlag = row.getChildText("creditDebitFlag");
            String hostTranCode = row.getChildText("hostTranCode");
            String opId = row.getChildText("opId");
            String opName = row.getChildText("opName");
            String oppAccountName = row.getChildText("oppAccountName");
            String oppAccountNo = row.getChildText("oppAccountNo");
            String oppOpenBankName = row.getChildText("oppOpenBankName");
            String sumTranNo = row.getChildText("sumTranNo");
            String tranAmount = ParserUtils.getUnNullElementTextValue((Element)row, (String)"tranAmount", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"DetailImpl_2", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]));
            String transDate = row.getChildText("tranDate");
            String tranNo = row.getChildText("tranNo");
            String tranTime = row.getChildText("tranTime");
            String valueDate = row.getChildText("valueDate");
            String chkNum = row.getChildText("chkNum");
            String refundFlag = row.getChildText("e3rtFlag");
            if ("0".equals(refundFlag)) {
                detail.setTransType(TransTypeEnum.REFUND.getName());
            }
            detail.setAccNo(accNo);
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            detail.setOppAccName(oppAccountName);
            detail.setOppAccNo(oppAccountNo);
            detail.setOppBankName(oppOpenBankName);
            LocalDateTime transTime = LocalDateTime.parse(transDate + tranTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detail.setTransTime(transTime);
            detail.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            if (creditDebitFlag.equalsIgnoreCase("D")) {
                detail.setDebitAmount(new BigDecimal(tranAmount));
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else {
                detail.setDebitAmount(new BigDecimal("0.00"));
                detail.setCreditAmount(new BigDecimal(tranAmount));
            }
            detail.setCurrency(request.getBankCurrency());
            detail.setExplanation(BizNoUtil.getMsg((String)"\u2605", (String)abstractText));
            if ("D".equalsIgnoreCase(creditDebitFlag)) {
                String KDRetFlag = "";
                if (!StringUtils.isEmpty((String)abstractText) && abstractText.contains("\u2605")) {
                    KDRetFlag = BizNoUtil.getIdNullAsBlank((String)"\u2605", (String)abstractText);
                    DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)KDRetFlag);
                } else if (!StringUtils.isEmpty((String)chkNum) && chkNum.indexOf("KD") != -1) {
                    KDRetFlag = chkNum.substring(2);
                    DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)KDRetFlag);
                }
                detail.setPayBankDetailSeqID(KDRetFlag);
            }
            if (!StringUtils.isEmpty((String)sumTranNo)) {
                DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)sumTranNo);
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            if (Objects.equals(hostTranCode, "1092025")) {
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                jsonObject.put("Amount", (Object)tranAmount);
                jsonObject.put("tranNo", (Object)"e");
                jsonObject.put("oppAccNo", (Object)oppAccountNo);
                receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonObject.toJSONString());
            } else {
                receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            }
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setJsonMap(jsonStr);
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(tranNo);
            detailList.add(i, detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "DLTRNALL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_3", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]);
    }
}

