/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service;

import java.util.List;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BocNetUtils {
    public static final String INSID_PREFIX = "KD_";
    public static final String INSID_PREFIX_NEW = "KD";
    public static final String TRANS_UP_FLAG = "trans_up";

    public static Element createRoot() {
        Element b2e = new Element("bocb2e");
        b2e.setAttribute("version", "120");
        b2e.setAttribute("security", "true");
        b2e.setAttribute("locale", "zh_CN");
        return b2e;
    }

    public static Element createHead(Element root, String trncod, String token) {
        EBContext context = EBContext.getContext();
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
        JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
        JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
        JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
        JDomUtils.addChild((Element)head, (String)"trncod", (String)trncod);
        JDomUtils.addChild((Element)head, (String)"token", (String)token);
        return head;
    }

    public static Element createRootWithHead(String token, String trncod) {
        Element root = BocNetUtils.createRoot();
        BocNetUtils.createHead(root, trncod, token);
        return root;
    }

    public static void batchSetReservedSysField(PaymentInfo[] infos, String key, String value) {
        for (PaymentInfo info : infos) {
            info.setSys(key, value);
        }
    }

    public static void batchSetReservedSysField(List<PaymentInfo> infos, String key, String value) {
        for (PaymentInfo info : infos) {
            info.setSys(key, value);
        }
    }

    public static String getSeqIdFromInsid(String insid) {
        if (insid.indexOf(INSID_PREFIX_NEW) > -1 && insid.length() > 8) {
            return insid.substring(INSID_PREFIX_NEW.length());
        }
        if (insid.contains(INSID_PREFIX)) {
            return insid.substring(INSID_PREFIX.length());
        }
        return insid;
    }

    public static String getBankDetailSeqId(PaymentInfo info) {
        if (info.getBankDetailSeqID().indexOf(INSID_PREFIX_NEW) > -1 && info.getBankDetailSeqID().length() > 8) {
            return info.getBankDetailSeqID();
        }
        if (info.getBankDetailSeqID().contains(INSID_PREFIX)) {
            return info.getBankDetailSeqID();
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            return BizNoUtil.prefixNew_cont((String)info.getBankDetailSeqID());
        }
        return info.getBankDetailSeqID();
    }

    public static String getBankBatchSeqId(PaymentInfo info) {
        if (info.getBankBatchSeqID().indexOf(INSID_PREFIX_NEW) > -1 && info.getBankBatchSeqID().length() > 8) {
            return info.getBankBatchSeqID();
        }
        if (info.getBankBatchSeqID().contains(INSID_PREFIX)) {
            return info.getBankBatchSeqID();
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            return BizNoUtil.prefixNew_cont((String)info.getBankBatchSeqID());
        }
        return info.getBankBatchSeqID();
    }

    public static String getInsid(PaymentInfo info) {
        String insid = info.getBankRefID();
        if (StringUtils.isEmpty((String)insid)) {
            insid = BocNetUtils.getBankDetailSeqId(info);
        }
        return insid;
    }

    public static String getInsid(PaymentInfo[] infos) {
        return BocNetUtils.getInsidFromBatch(infos[0]);
    }

    public static String getInsidFromBatch(PaymentInfo info) {
        String insid = info.getBankRefID();
        if (StringUtils.isEmpty((String)insid)) {
            insid = BocNetUtils.getBankBatchSeqId(info);
        }
        return insid;
    }
}

