/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.CashPoolHelper;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBatchBalanceImpl
extends AbstractBalanceImpl
implements IHisBatchBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(HisBatchBalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(BankBalanceRequest request) {
        boolean flag = !CashPoolHelper.isCashPoolAcnt(request.getHeader().getAcnt().getAccNo()) && !BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo()) && !BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo());
        if (request.getEndDate() != null && (flag &= BankBusinessConfig.isBatchBalanceQuery())) {
            return LocalDate.now().isAfter(request.getEndDate());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest request) {
        Objects.requireNonNull(request.getStartDate(), ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisBatchBalanceImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
        Objects.requireNonNull(request.getEndDate(), ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HisBatchBalanceImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
        List bankAcntList = request.getBankAcntList();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader(token, "b2e0012");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0012-rq");
            for (BankAcnt acnt : bankAcntList) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0012-rq");
                Element account = JDomUtils.addChild((Element)rq, (String)"account");
                JDomUtils.addChild((Element)account, (String)"ibknum", (String)acnt.getCnaps());
                JDomUtils.addChild((Element)account, (String)"actacn", (String)acnt.getAccNo());
                Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
                JDomUtils.addChild((Element)datescope, (String)"from", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
                JDomUtils.addChild((Element)datescope, (String)"to", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                this.logger.error("\u6279\u91cf\u5386\u53f2\u4f59\u989d\u63a5\u53e3\u67e5\u8be2\u6253\u5305\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0012-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        ArrayList<BalanceInfo> hisBalanceList = new ArrayList<BalanceInfo>(16);
        List rsList = trn.getChildren("b2e0012-rs");
        for (Element rs : rsList) {
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            Element account = rs.getChild("account");
            String actacn = account.getChildTextTrim("actacn");
            String curcde = account.getChildTextTrim("curcde");
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, request.getBankAcntList(), actacn);
            if (!"B001".equalsIgnoreCase(another_rspcod)) {
                balanceInfo.setError(ShowTipUtil.getResponseErrorTips((String)another_rspcod, (String)another_rspmsg));
            } else {
                Element balance = rs.getChild("balance");
                String bokbal = balance.getChildTextTrim("bokbal");
                String avabal = balance.getChildTextTrim("avabal");
                String baldat = rs.getChildTextTrim("baldat");
                this.setLastDayAvlBalance(balanceInfo, bokbal);
                this.setCurrentBalance(balanceInfo, avabal);
                this.setAvailableBalance(balanceInfo, avabal);
                this.setBankCurrency(balanceInfo, request.getCurrency(), curcde);
                this.setBalanceDateTime(balanceInfo, baldat + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            }
            hisBalanceList.add(balanceInfo);
        }
        return new EBBankBalanceResponse(hisBalanceList);
    }

    public EBBankBalanceResponse batchBalance(BankBalanceRequest request) {
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList balanceInfos = new ArrayList(16);
        EBBankBalanceResponse response = this.doBiz(request);
        balanceInfos.addAll(response.getBalances());
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    public int limit() {
        return 15;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0012";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"b2e0012\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBatchBalanceImpl_3", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }
}

